/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.editor;

import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.rosuda.JGR.editor.EditorPreferences;

public class SyntaxDocument
extends DefaultStyledDocument {
    private DefaultStyledDocument doc = this;
    private Element rootElement = this.doc.getDefaultRootElement();
    private static MutableAttributeSet BOLD = new SimpleAttributeSet();

    public SyntaxDocument() {
        StyleConstants.setBold(BOLD, true);
        this.putProperty("__EndOfLine__", "\n");
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        boolean bl = false;
        if (string.equals("\t")) {
            try {
                bl = this.getText(n - 1, 1).matches("[\\s|#]");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!bl && n != 0) {
                string = string.replaceAll("\t", "");
            } else {
                String string2 = "";
                for (int i = 0; i < EditorPreferences.tabWidth; ++i) {
                    string2 = string2 + " ";
                }
                string = string2;
            }
        } else if (string.equals("\n")) {
            int n2;
            int n3 = this.rootElement.getElementIndex(n);
            int n4 = n2 = this.rootElement.getElement(n3).getStartOffset();
            try {
                while (this.getText(n4++, 1).matches("[\\t\\x0B\\f]")) {
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string = "\n" + this.getText(n2, n4 - n2 - 1).replaceAll("\n", "");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.insertString(n, string, attributeSet);
    }

    public void remove(int n, int n2) throws BadLocationException {
        if (n == -1) {
            return;
        }
        super.remove(n, n2);
    }

    private synchronized void processChangedLines(int n, int n2) throws BadLocationException {
        String string = this.doc.getText(0, this.doc.getLength());
        int n3 = this.rootElement.getElementIndex(n);
        int n4 = this.rootElement.getElementIndex(n + n2);
        for (int i = n3; i <= n4; ++i) {
            this.applyHighlighting(string, i);
        }
    }

    private synchronized void applyHighlighting(String string, int n) {
        int n2;
        int n3 = this.rootElement.getElement(n).getStartOffset();
        int n4 = this.rootElement.getElement(n).getEndOffset() - 1;
        int n5 = n4 - n3;
        if (n5 < 0) {
            n5 = 0;
        }
        if (n4 >= (n2 = string.length())) {
            n4 = n2 - 1;
        }
        this.doc.setCharacterAttributes(n3, n5, EditorPreferences.NORMAL, true);
        int n6 = string.indexOf(this.getSingleLineDelimiter(), n3);
        if (n6 > -1 && n6 < n4) {
            this.doc.setCharacterAttributes(n6, n4 - n6 + 1, EditorPreferences.COMMENT, false);
            n4 = n6 - 1;
        }
        this.checkForTokens(string, n3, n4);
    }

    private synchronized void checkForTokens(String string, int n, int n2) {
        while (n <= n2) {
            while (this.isDelimiter(string.substring(n, n + 1))) {
                if (n < n2) {
                    ++n;
                    continue;
                }
                return;
            }
            if (this.isQuoteDelimiter(string.substring(n, n + 1))) {
                n = this.getQuoteToken(string, n, n2);
                continue;
            }
            n = this.getOtherToken(string, n, n2);
        }
    }

    private synchronized int getQuoteToken(String string, int n, int n2) {
        String string2 = string.substring(n, n + 1);
        String string3 = this.getEscapeString(string2);
        int n3 = n;
        int n4 = string.indexOf(string3, n3 + 1);
        while (n4 > -1 && n4 < n2) {
            n3 = n4 + 1;
            n4 = string.indexOf(string3, n3);
        }
        n4 = string.indexOf(string2, n3 + 1);
        n3 = n4 < 0 || n4 > n2 ? n2 : n4;
        this.doc.setCharacterAttributes(n, n3 - n + 1, EditorPreferences.QUOTE, false);
        return n3 + 1;
    }

    private synchronized int getOtherToken(String string, int n, int n2) {
        int n3;
        for (n3 = n + 1; n3 <= n2 && !this.isDelimiter(string.substring(n3, n3 + 1)); ++n3) {
        }
        String string2 = string.substring(n, n3);
        if (this.isKeyword(string2)) {
            this.doc.setCharacterAttributes(n, n3 - n, EditorPreferences.KEYWORD, false);
        }
        if (this.isObject(string2)) {
            this.doc.setCharacterAttributes(n, n3 - n, EditorPreferences.OBJECT, false);
        } else if (this.isNumber(string2)) {
            this.doc.setCharacterAttributes(n, n3 - n, EditorPreferences.NUMBER, false);
        }
        return n3 + 1;
    }

    protected synchronized boolean isDelimiter(String string) {
        String string2 = ",;:{}()[]+-/%<=>!&|^~*$";
        return Character.isWhitespace(string.charAt(0)) || string2.indexOf(string) != -1;
    }

    protected synchronized boolean isQuoteDelimiter(String string) {
        return "\"'".indexOf(string) >= 0;
    }

    protected synchronized boolean isKeyword(String string) {
        Object v = EditorPreferences.KEYWORDS.get(string);
        return v != null;
    }

    protected synchronized boolean isNumber(String string) {
        return string.matches("[[0-9]+.[0-9]+]*[0-9]+");
    }

    protected synchronized boolean isObject(String string) {
        Object v = EditorPreferences.KEYWORDS_OBJECTS.get(string);
        return v != null;
    }

    protected synchronized String getSingleLineDelimiter() {
        return "#";
    }

    protected synchronized String getEscapeString(String string) {
        return "\\" + string;
    }

    protected synchronized String addMatchingBrace(int n) throws BadLocationException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.rootElement.getElementIndex(n);
        int n3 = this.rootElement.getElement(n2).getStartOffset();
        while ((string = this.doc.getText(n3, 1)).equals(" ") || string.equals("\t")) {
            stringBuffer.append(string);
            ++n3;
        }
        return "{\n" + stringBuffer.toString() + stringBuffer.toString() + "\n" + stringBuffer.toString() + "}";
    }

    protected void fireInsertUpdate(DocumentEvent documentEvent) {
        super.fireInsertUpdate(documentEvent);
        try {
            this.processChangedLines(documentEvent.getOffset(), documentEvent.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected void fireRemoveUpdate(DocumentEvent documentEvent) {
        super.fireRemoveUpdate(documentEvent);
        try {
            this.processChangedLines(documentEvent.getOffset(), documentEvent.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

