/*
 * Decompiled with CFR 0.152.
 */
package j4r.multiprocess;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

abstract class AbstractIndependentProcess
implements Runnable {
    private StateValue state;
    private boolean isCancelled = false;
    private int exitValue = -1;
    private Exception exceptionWhileRunning;
    private String name;
    private boolean redirectOutputStream = true;
    private final transient Object lock = new Object();
    private final transient Object communicationHandlerLock = new Object();
    private transient Collection<PropertyChangeListener> listeners = new CopyOnWriteArrayList<PropertyChangeListener>();
    private transient Process process;
    private transient IndependentProcessCommunicationHandler communicationHandler;
    private transient Thread worker;

    protected AbstractIndependentProcess() {
        this.setState(StateValue.PENDING);
        this.redirectOutputStream(true);
        this.worker = new Thread(this);
        this.worker.setDaemon(true);
        this.worker.setName(String.valueOf(this.getClass().getSimpleName()) + " - ProcessHandler");
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isCancelled || this.state == StateValue.DONE) {
            return false;
        }
        if (this.state == StateValue.PENDING) {
            this.isCancelled = true;
            return true;
        }
        if (mayInterruptIfRunning) {
            if (this.process != null) {
                this.process.destroy();
                this.isCancelled = true;
                this.setState(StateValue.DONE);
            }
            return true;
        }
        return false;
    }

    public Integer get() throws InterruptedException, ExecutionException {
        try {
            return this.get(0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new ExecutionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer get(long duration, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        long timeToWait = timeUnit.toMillis(duration);
        Object object = this.lock;
        synchronized (object) {
            while (this.getState() != StateValue.DONE) {
                if (timeToWait == 0L) {
                    this.lock.wait();
                    continue;
                }
                this.lock.wait(timeToWait);
                if (this.getState() == StateValue.DONE) continue;
                throw new TimeoutException();
            }
        }
        if (this.exceptionWhileRunning != null) {
            throw new ExecutionException(this.exceptionWhileRunning);
        }
        return this.exitValue;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public StateValue getState() {
        return this.state;
    }

    public boolean isDone() {
        return this.getState() == StateValue.DONE;
    }

    protected abstract Process createIndependentProcess() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.getState() == StateValue.PENDING) {
            Object object;
            try {
                this.process = this.createIndependentProcess();
                this.setState(StateValue.STARTED);
                object = this.communicationHandlerLock;
                synchronized (object) {
                    this.communicationHandlerLock.notify();
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream(), "UTF-8"));
                String lineReceived = reader.readLine();
                String previousMessage = null;
                while (lineReceived != null) {
                    this.firePropertyChange("MessageReceived", previousMessage, lineReceived);
                    if (this.redirectOutputStream) {
                        System.out.println("PROCESS " + this.getName() + ": " + lineReceived);
                    }
                    previousMessage = lineReceived;
                    lineReceived = reader.readLine();
                }
                this.exitValue = this.process.waitFor();
            }
            catch (IOException e) {
                this.exceptionWhileRunning = e;
            }
            catch (InterruptedException e) {
                this.exceptionWhileRunning = e;
            }
            object = this.lock;
            synchronized (object) {
                this.setState(StateValue.DONE);
                this.lock.notify();
            }
        }
    }

    private void setState(StateValue stateValue) {
        StateValue formerValue = this.state;
        this.state = stateValue;
        this.firePropertyChange("state", (Object)formerValue, (Object)this.state);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(evt);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        while (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private IndependentProcessCommunicationHandler getCommunicationHandler() {
        if (this.communicationHandler == null) {
            this.communicationHandler = new IndependentProcessCommunicationHandler(this);
        }
        return this.communicationHandler;
    }

    public void execute() {
        this.worker.start();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void sendObjectToProcess(Serializable obj) throws IOException {
        this.getCommunicationHandler().writeObject(obj);
    }

    public void redirectOutputStream(boolean redirectOutputStream) {
        this.redirectOutputStream = redirectOutputStream;
    }

    private static class IndependentProcessCommunicationHandler
    implements Runnable {
        private AbstractIndependentProcess abstractIndependentProcess;
        private Thread emittingThread;
        private ConcurrentLinkedQueue<Serializable> queue;

        private IndependentProcessCommunicationHandler(AbstractIndependentProcess abstractIndependentProcess) {
            this.abstractIndependentProcess = abstractIndependentProcess;
            this.queue = new ConcurrentLinkedQueue();
            this.emittingThread = new Thread(this);
            this.emittingThread.setDaemon(true);
            this.emittingThread.setName(String.valueOf(abstractIndependentProcess.getClass().getSimpleName()) + " - CommHandler");
            this.emittingThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block9: {
                if (this.abstractIndependentProcess.getState() != StateValue.DONE) {
                    try {
                        Object object = this.abstractIndependentProcess.communicationHandlerLock;
                        synchronized (object) {
                            while (this.abstractIndependentProcess.getState() == StateValue.PENDING) {
                                this.abstractIndependentProcess.communicationHandlerLock.wait();
                            }
                        }
                        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(this.abstractIndependentProcess.process.getOutputStream()));
                        while (this.abstractIndependentProcess.getState() == StateValue.STARTED) {
                            Serializable toBeSent = this.queue.poll();
                            if (toBeSent == null) continue;
                            oos.writeObject(toBeSent);
                            oos.flush();
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        String message = "Communication channel shutted down";
                        this.abstractIndependentProcess.firePropertyChange("MessageReceived", null, message);
                        if (!this.abstractIndependentProcess.redirectOutputStream) break block9;
                        System.out.println("PROCESS " + this.abstractIndependentProcess.getName() + ": " + message);
                    }
                }
            }
        }

        private void writeObject(Serializable obj) throws IOException {
            this.queue.add(obj);
        }
    }

    public static enum StateValue {
        DONE,
        PENDING,
        STARTED;

    }
}

