% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/j4rFunctions.R
\name{callJavaMethod}
\alias{callJavaMethod}
\title{Call a Java method}
\usage{
callJavaMethod(source, methodName, ...)
}
\arguments{
\item{source}{this should be either a java.list instance or a single java.object instance for non-static methods or
a string representing the Java class name in case of static method}

\item{methodName}{the name of the method}

\item{...}{the parameters of the method}
}
\value{
It depends on the method. It can return a primitive type (or a vector of primitive), a Java instance (or a list of Java instances) or nothing at all.
}
\description{
This function calls a public method in a particular class of object. If the javaObject parameters or the additional
parameters (...) include vectors, the method is called several times and a vector of primitive or a list of java
instances can be returned.
}
\details{
There is no need to cast a particular parameter to a super class. Actually, the Java server tries to find the method
that best matches the types of the parameters
}
\examples{
### starting Java
connectToJava()

### creating an empty ArrayList object
myList <- createJavaObject("java.util.ArrayList")

### adding 3 to the list
callJavaMethod(myList, "add", 3)

### shutting down Java
shutdownJava()

}
\seealso{
\href{https://sourceforge.net/p/repiceasource/wiki/J4R/}{J4R webpage}
}
