% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plots}
\alias{plots}
\alias{plot.ISOFIT}
\alias{plot.ISOSCAPE}
\alias{plot.CALIBFIT}
\alias{plot.ISOFIND}
\alias{plot.RasterLayer}
\alias{plot}
\alias{points.CALIBFIT}
\title{Plotting functions for IsoriX}
\usage{
\method{plot}{ISOSCAPE}(
  x,
  which = "mean",
  y_title = list(which = TRUE, title = bquote(delta^2 * H)),
  sources = list(draw = TRUE, cex = 0.5, pch = 2, lwd = 1, col = "red"),
  borders = list(borders = NA, lwd = 0.5, col = "black"),
  mask = list(mask = NA, lwd = 0, col = "black", fill = "black"),
  palette = list(step = NA, range = c(NA, NA), n_labels = 11, digits = 2, fn = NA),
  plot = TRUE,
  sphere = list(build = FALSE, keep_image = FALSE),
  ...
)

\method{plot}{ISOFIND}(
  x,
  who = "group",
  cutoff = list(draw = TRUE, level = 0.05, col = "#909090"),
  sources = list(draw = TRUE, cex = 0.5, pch = 2, lwd = 1, col = "red"),
  calibs = list(draw = TRUE, cex = 0.5, pch = 4, lwd = 1, col = "blue"),
  assigns = list(draw = TRUE, cex = 0.5, pch = 5, lwd = 1, col = "white"),
  borders = list(borders = NA, lwd = 0.5, col = "black"),
  mask = list(mask = NA, lwd = 0, col = "black", fill = "black"),
  mask2 = list(mask = NA, lwd = 0, col = "purple", fill = "purple"),
  palette = list(step = NA, range = c(0, 1), n_labels = 11, digits = 2, fn = NA),
  plot = TRUE,
  sphere = list(build = FALSE, keep_image = FALSE),
  ...
)

\method{plot}{ISOFIT}(x, cex_scale = 0.2, ...)

\method{plot}{CALIBFIT}(
  x,
  pch = 1,
  col = "black",
  xlab = "Isotopic value in the environment",
  ylab = "Isotopic value in the calibration sample",
  xlim = NULL,
  ylim = NULL,
  line = list(show = TRUE, col = "blue"),
  CI = list(show = TRUE, col = "blue"),
  plot = TRUE,
  ...
)

\method{points}{CALIBFIT}(
  x,
  pch = 2,
  col = "red",
  line = list(show = TRUE, col = "red"),
  CI = list(show = TRUE, col = "red"),
  plot = TRUE,
  ...
)

\method{plot}{RasterLayer}(x, ...)
}
\arguments{
\item{x}{The return object of a call to \link{isofit}, \link{isoscape}, \link{calibfit},
\link{isofind}, or \link[raster:raster]{raster::raster}]}

\item{which}{A \emph{string} indicating the name of the raster to be plotted
(see details)}

\item{y_title}{A \emph{list} containing information for the display of the
title (see details)}

\item{sources}{A \emph{list} containing information for the display of the
location of the sources (see details)}

\item{borders}{A \emph{list} containing information for the display of borders
(e.g. country borders) (see details)}

\item{mask}{A \emph{list} containing information for the display of a mask
(e.g. an ocean mask) (see details)}

\item{palette}{A \emph{list} containing information for the display of the
colours for the isoscape (see details)}

\item{plot}{A \emph{logical} indicating whether the plot shall be plotted or
just returned}

\item{sphere}{A \emph{list} containing information whether the raster should
be returned as a rotating sphere and if the image created during the
process should be saved in your current working directory. The default
settings are FALSE.}

\item{...}{Additional arguments (only in use in plot.CALIBFIT and
plot.RasterLayer)}

\item{who}{Either "group", or a vector of indices (e.g. 1:3) or names of the
individuals (e.g. c("Mbe_1", "Mbe_3")) to be considered in assignment plots}

\item{cutoff}{A \emph{list} containing information for the display of the
region outside the prediction interval (see details)}

\item{calibs}{A \emph{list} containing information for the display of the
location of the calibration sampling location (see details)}

\item{assigns}{A \emph{list} containing information for the display of the
location of the assingment sampling location (see details)}

\item{mask2}{A \emph{list} containing information for the display of a mask
(e.g. a distribution mask) (see details)}

\item{cex_scale}{A \emph{numeric} giving a scaling factor for the points in
the plots}

\item{pch}{The argument pch as in \link{par} for plot.CALIBFIT and
points.CALIBFIT}

\item{col}{The argument col as in \link{par} for plot.CALIBFIT and
points.CALIBFIT}

\item{xlab}{A \emph{string} the x-axis label in plot.CALIBFIT}

\item{ylab}{A \emph{string} the y-axis label in plot.CALIBFIT}

\item{xlim}{A range defining the extreme coordinates for the the x-axis in
plot.CALIBFIT}

\item{ylim}{A range defining the extreme coordinates for the the y-axis in
plot.CALIBFIT}

\item{line}{A \emph{list} containing two elements: \code{show}, a
\emph{logical} indicating whether to show the regression line or not; and
\code{col}, a \emph{string} or \emph{integer} indicating the colour for
plotting the regression line}

\item{CI}{A \emph{list} containing two elements: \code{show}, a \emph{logical}
indicating whether to show the confidence interval or not; and \code{col},
a \emph{string} or \emph{integer} indicating the colour for plotting the
confidence interval}
}
\description{
These functions plot objects created by IsoriX (with the exception of plot
method for RasterLayer created using \link{raster}.
}
\details{
\strong{General}

When called upon an object of class \emph{ISOFIT}, the plot function
draws diagnostic information for the fits of the isoscape geostatistical
model.

When called upon an object of class \emph{CALIBFIT}, the plot function draws the
fitted calibration function.

When called upon an object of class \emph{ISOSCAPE}, the plot function draws a
fine-tuned plot of the isoscape.

When called upon an object of class \emph{RasterLayer}, the plot function displays
the raster (just for checking things fast and dirty). In this case, the
function is a simple shortcut to \link[rasterVis:levelplot-methods]{rasterVis::levelplot}.

\strong{Plotting isoscapes}

When used on a fitted isoscape, the user can choose between plotting the
predictions (\code{which = "mean"}; default), the prediction variance (\code{which = "mean_predVar"}), the residual variance (\code{which = "mean_residVar"}), or the
response variance (\code{which = "mean_respVar"}) for the mean model; or the
corresponding information for the residual dispersion variance model
(\code{"disp"}, \code{"disp_predVar"}, \code{"disp_residVar"}, or \code{"disp_respVar"}).

When used on a simulated isoscape produced with the function \code{isosim}
(currently dropped due to the package RandomFields being temporarily retired
from CRAN), the user can choose between plotting the mean isotopic value
(\code{which = "mean"}) or the residual dispersion (\code{which = "disp"}).

\strong{Plotting assignments}

When called upon an object of class \emph{ISOFIND}, the plot function draws a
fine-tuned plot of the assignment. You can use the argument \code{who} to choose
between plotting the assignment for the group or for some individuals (check
the \href{https://bookdown.org/content/782/}{online tutorial} for examples).

\strong{Info on parameters influencing the rendering of maps}

The argument \code{y_title} is a list that can be tweaked to customise the title
of isoscapes. Within this list, the element \code{which} is a logical indicating
if the name of the layer should be displayed or not. The element \code{title} is a
string or a call used to define the rest of the title. By default it draws
the delta value for hydrogen. Check the syntax of this default before trying
to modify it.

The arguments \code{cutoff}, \code{sources}, \code{calibs}, \code{assigns}, \code{borders}, \code{mask},
and \code{mask2} are used to fine-tune additional layers that can be added to the
main plot to embellish it. These arguments must be lists that provide details
on how to draw, respectively, the area outside the prediction interval (for
assignment plots), the locations of sources (for both isoscape and assignment
plots), the locations of the calibration samples (for assignment plots), the
locations of the assignment samples (for assignment plots), the borders (for
both types of plots), and the mask (again, for both). For assignment maps, an
extra mask can be used (mask2), as one may want to add a mask covering the
area outside the biological range of the species. Within these lists, the
elements \code{lwd}, \code{col}, \code{cex}, \code{pch} and \code{fill} influences their respective
objects as in traditional R plotting functions (see \link{par} for details). The
element \code{draw} should be a \emph{logical} that indicates whether the layer must be
created or not. The argument \code{borders} (within the list borders) expects an
object of the class \emph{SpatialPolygons} such as the object \link{CountryBorders}
provided with this package. The argument \code{mask} (within the list mask)
expects an object of the class \emph{SpatialPolygons} such as the object
\link{OceanMask} provided with this package (see examples).

The argument \code{palette} is used to define how to colour the isoscape and
assignment plot. Within this list, \code{step} defines the number of units on the
z-scale that shares a given colour; \code{range} can be used to constrain the
minimum and/or maximum values to be drawn (e.g. range = c(0, 1)) (this latter
argument is useful if one wants to create several plots with the same
z-scale); \code{n_labels} allows for the user to approximatively define the
maximum number of numbers plotted on the z-scale; \code{digits} defines the number
of digits displayed for the numbers used as labels; and \code{fn} is used to
specify the function that is used to sample the colours. If \code{fn} is NULL
(default) the palette functions derived from \link{isopalette1} and \link{isopalette2}
are used when plotting isoscape and assignments, respectively. If \code{fn} is NA
the function used is the palette \link[viridisLite:viridis]{viridisLite::viridis}.

\strong{Default symbols used on maps}

Under the default settings, we chose to
represent:
\itemize{
\item the source data by little red triangles.
\item the calibration data by little blue crosses.
\item the locations where the samples to assign were collected by white
diamonds.
}

These symbols can be changed as explained above.
}
\examples{
## See ?isoscape or ?isofind for examples

}
\seealso{
\link{isofit} for the function fitting the isoscape

\link{isoscape} for the function building the isoscape

\link{calibfit} for the function fitting the calibration function

\link{isofind} for the function performing the assignment
}
\keyword{plot}
