% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IIWcode.R
\name{outputation}
\alias{outputation}
\title{Create an outputted dataset for use with multiple outputation.}
\usage{
outputation(data, weights, singleobs, id, time, keep.first)
}
\arguments{
\item{data}{the original dataset on which multiple outputation is to be performed}

\item{weights}{the weights to be used in the outputation, i.e. the inverse of the probability that a given observation will be selected in creating an outputted dataset. Ignored if singleobs=TRUE}

\item{singleobs}{logical variable indicating whether a single observation should be retained for each subject}

\item{id}{character string indicating which column of the data identifies subjects}

\item{time}{character string indicating which column of the data contains the time at which the visit occurred}

\item{keep.first}{logical variable indicating whether the first observation should be retained with probability 1. This is useful if the data consists of an observation at baseline followed by follow-up at stochastic time points.}
}
\value{
the outputted dataset.
}
\description{
Multiple outputation is a procedure whereby excess observations are repeatedly randomly sampled and discarded. The method was originally developed to handle clustered data where cluster size is informative, for example when studying pups in a litter. In this case, analysis that ignores cluster size results in larger litters being over-represented in a marginal analysis. Multiple outputation circumvents this problem by randomly selecting one observation per cluster. Multiple outputation has been further adapted to handle longitudinal data subject to irregular observation; here the probability of being retained on any given outputation is inversely proportional to the visit intensity. This function creates a single outputted dataset.
}
\examples{
library(nlme)
data(Phenobarb)
library(survival)
library(geepack)
Phenobarb$event <- 1-as.numeric(is.na(Phenobarb$conc))
data <- lagfn(Phenobarb, lagvars="dose", id="Subject", time="time", lagfirst = 0)
data <- lagfn(data, lagvars="dose.lag", id="Subject", time="time", lagfirst = 0)
data <- lagfn(data, lagvars="dose.lag.lag", id="Subject", time="time", lagfirst = 0)
data$dose.lag[is.na(data$dose.lag)] <- data$dose.lag.lag[is.na(data$dose.lag)]
data$dose.lag[is.na(data$dose.lag)] <- data$dose.lag.lag.lag[is.na(data$dose.lag)]
data <- data[data$event==1,]
data$id <- as.numeric(data$Subject)
data <- data[data$time<16*24,]
i <- iiw.weights(Surv(time.lag,time,event)~Wt *dose.lag + dose.lag*(I(conc.lag>0) + conc.lag) +
cluster(Subject),id="id",time="time",event="event",data=data,
invariant="Subject",lagvars=c("time","conc"),maxfu=16*24,lagfirst=0,first=TRUE)
data$weight <- i$iiw.weight
head(data)
data.output1 <-   outputation(data,data$weight,singleobs=FALSE,
id="id",time="time",keep.first=FALSE)
head(data.output1)
data.output2 <-   outputation(data,data$weight,singleobs=FALSE,
id="id",time="time",keep.first=FALSE)
head(data.output2)
data.output3 <-   outputation(data,data$weight,singleobs=FALSE,
id="id",time="time",keep.first=FALSE)
head(data.output3)
# Note that the outputted dataset varies with each command run; outputation is done at random
}
\references{
\itemize{
\item Hoffman E, Sen P, Weinberg C. Within-cluster resampling. Biometrika 2001; 88:1121-1134
\item Follmann D, Proschan M, Leifer E. Multiple outputation: inference for complex clustered data by averaging analyses from independent data. Biometrics 2003; 59:420-429
\item Pullenayegum EM. Multiple outputation for the analysis of longitudinal data subject to irregular observation. Statistics in Medicine (in press).}
}
\seealso{
Other mo: 
\code{\link{mo}()}
}
\concept{mo}
