% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-var.R
\docType{methods}
\name{var}
\alias{var}
\alias{var,IntervalList-method}
\title{Calculate the sample Frechet variance of \eqn{n} interval-valued data}
\usage{
\S4method{var}{IntervalList}(x, theta = 1)
}
\arguments{
\item{x}{a list of interval-valued data.}

\item{theta}{a single positive numeric value. By default, \code{theta}=1.}
}
\value{
Returns the calculated sample Frechet variance of \eqn{n} interval-valued data, i.e., a real number.
}
\description{
This function calculates the sample Frechet variance of \eqn{n} interval-valued data.
}
\details{
Let \eqn{\mathcal{X}} be an interval-valued random set
and let \eqn{\left(x_{1},x_{2},\ldots,x_{n}\right)} be a sample of \eqn{n}
independent observations drawn from \eqn{\mathcal{X}}.Then, the sample Frechet variance is defined as follows,
\deqn{s_{\mathcal{X}}^{2}=\frac{1}{n}\sum_{i=1}^{n}d_{\theta}^{2}\left(x_{i}, \overline{x}\right)} where \eqn{\theta>0} and
\eqn{\overline{x}} denotes the sample Aumann mean of \eqn{\left(x_{1},x_{2},\ldots,x_{n}\right)}.
}
\examples{
var(IntervalList(c(1, 3), c(2, 5)))
var(IntervalList(c(1, 3), c(2, 5)), 1/3)
}
\references{
Frechet, M. (1948). Les elements aleatoires de nature quelconque dans un espace distancie.
Annales de l'institut Henri Poincare, 10(4):215-310.
}
\seealso{
Other IntervalList-method: 
\code{\link{IntervalList-class}},
\code{\link{IntervalList}},
\code{\link{as.IntervalList}()},
\code{\link{cov}()},
\code{\link{ivd2likert}()},
\code{\link{ivd2vas}()},
\code{\link{mean}()},
\code{\link{plot}()},
\code{\link{sum}()}
}
\author{
Jose Garcia Garcia \email{garciagarjose@uniovi.es}
}
\concept{IntervalList-method}
