% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-plot.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,IntervalData,missing-method}
\alias{plot,IntervalData,IntervalData-method}
\alias{plot,IntervalList,missing-method}
\alias{plot,IntervalList,IntervalList-method}
\title{Plot an interval-valued data or a list of interval-valued data}
\usage{
\S4method{plot}{IntervalData,missing}(x, y, layout = c("vertical","horizontal"), bounds = FALSE, mid = FALSE, \dots)
\S4method{plot}{IntervalData,IntervalData}(x, y, bounds = FALSE, \dots)
\S4method{plot}{IntervalList,missing}(x, y, layout = c("vertical","horizontal"), bounds = FALSE, mid = FALSE, \dots)
\S4method{plot}{IntervalList,IntervalList}(x, y, bounds = FALSE, \dots)
}
\arguments{
\item{x}{an object of type \code{IntervalData} or \code{IntervalList} representing the values of an interval-value variable.}

\item{y}{an object of type \code{IntervalData} or \code{IntervalList} representing the values of a second interval-value variable, to be displayed along y (vertical) coordinates.}

\item{layout}{the axes along which the interval-valued variables be displayed. Alternatives are "vertical" (default) and "horizontal".}

\item{bounds}{a logical value indicating if interval bounds should be plotted or not (default).}

\item{mid}{a logical value indicating if the interval mid-points should be plotted or not (default).}

\item{\dots}{graphical arguments to be passed to methods.}
}
\value{
This function does not return any value. It only plots interval-valued data.
}
\description{
S4 methods for function plot.
As in the generic plot S3 `graphics' method, these methods plot interval-valued data contained
in \code{IntervalData} and \code{IntervalList} objects.
}
\examples{
i1 <- IntervalData(0, 1)
i2 <- IntervalData(2, 3)
plot(i1)
plot(i1, bounds = TRUE, mid = TRUE)
plot(i1, i2)
plot(i1, i2, bounds = TRUE)

list1 <- IntervalList(c(0, 3, 2, 5, 6), c(4, 5, 4, 8, 7))
list2 <- IntervalList(c(3, 0, 3, 1, 4), c(7, 4, 6, 2, 6))
plot(list1)
plot(list1, layout = "horizontal")
plot(list1, bounds = TRUE, mid = TRUE)
plot(list1, list2)
plot(list1, list2, bounds = TRUE)

## Extra arguments
plot(list1, list2, bounds = TRUE, main = "My interval-valued data plot", col = "blue", lwd = 2)
}
\seealso{
Other IntervalData-method: 
\code{\link{IntervalData-class}},
\code{\link{IntervalData}},
\code{\link{arithmetic}},
\code{\link{as.IntervalData}()},
\code{\link{distance}()},
\code{\link{ivd2likert}()},
\code{\link{ivd2vas}()},
\code{\link{show}()}

Other IntervalList-method: 
\code{\link{IntervalList-class}},
\code{\link{IntervalList}},
\code{\link{as.IntervalList}()},
\code{\link{cov}()},
\code{\link{ivd2likert}()},
\code{\link{ivd2vas}()},
\code{\link{mean}()},
\code{\link{sum}()},
\code{\link{var}()}
}
\author{
Jose Garcia Garcia \email{garciagarjose@uniovi.es}
}
\concept{IntervalData-method}
\concept{IntervalList-method}
