% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_interaction.R
\name{power_interaction}
\alias{power_interaction}
\title{Power analysis for interactions}
\usage{
power_interaction(
  n.iter,
  N,
  r.x1.y,
  r.x2.y,
  r.x1x2.y,
  r.x1.x2,
  rel.x1 = 1,
  rel.x2 = 1,
  rel.y = 1,
  skew.x1 = 0,
  skew.x2 = 0,
  skew.y = 0,
  k.x1 = 0,
  k.x2 = 0,
  k.y = 0,
  transform.x1 = "default",
  transform.x2 = "default",
  transform.y = "default",
  adjust.correlations = TRUE,
  alpha = 0.05,
  q = 2,
  cl = NULL,
  ss.IQR = 1.5,
  N.adjustment = 1e+06,
  detailed_results = FALSE,
  full_simulation = FALSE,
  tol = 0.005,
  iter = 10
)
}
\arguments{
\item{n.iter}{Number of iterations. The number of simulations to run for each unique setting combination. Must be a positive integer.}

\item{N}{Sample size. Must be a positive integer. Has no default value. Can be a single value or a vector of values.}

\item{r.x1.y}{Pearson's correlation between x1 and y. Must be between -1 and 1.. Has no default value. Can be a single value or a vector of values.}

\item{r.x2.y}{Pearson's correlation between x2 and y. Must be between -1 and 1.. Assumed to be the 'moderator' in some functions. Has no default value. Can be a single value or a vector of values.}

\item{r.x1x2.y}{Pearson's correlation between the interaction term x1x2 (x1 * x2) and y. Must be between -1 and 1.. Has no default value. Can be a single value or a vector of values.}

\item{r.x1.x2}{Pearson's correlation between x1 and x2. Must be between -1 and 1.. Has no default value. Can be a single value or a vector of values.}

\item{rel.x1}{Reliability of x1 (e.g. test-retest reliability, ICC, Cronbach's alpha). Default is 1 (perfect reliability). Must be greater than 0 and less than or equal to 1.}

\item{rel.x2}{Reliability of x2 (e.g. test-retest reliability, ICC, Cronbach's alpha). Default is 1 (perfect reliability). Must be greater than 0 and less than or equal to 1.}

\item{rel.y}{Reliability of xy (e.g. test-retest reliability, ICC, Cronbach's alpha). Default is 1 (perfect reliability). Must be greater than 0 and less than or equal to 1.}

\item{skew.x1}{Skew of x1. Default is 0 (normally distributed).}

\item{skew.x2}{Skew of x2. Default is 0 (normally distributed).}

\item{skew.y}{Skew of y. Default is 0 (normally distributed).}

\item{k.x1}{Number of discrete values for x1. k.x1 = 2 is equivalent to transform.x1 = "binary". Performs best with k<= 5 if variable is skewed. Otherwise, up to k=20. Values less than 2 result in a continuous variable.}

\item{k.x2}{Number of discrete values for x2. k.x2 = 2 is equivalent to transform.x2 = "binary". Performs best with k<= 5 if variable is skewed. Otherwise, up to k=20. Values less than 2 result in a continuous variable.}

\item{k.y}{Number of discrete values for y. k.y = 2 is equivalent to transform.y = "binary". Performs best with k<= 5 if variable is skewed. Otherwise, up to k=20. Values less than 2 result in a continuous variable.}

\item{transform.x1}{Transform x1? Options are "default", "binary", or "gamma". "binary" will cause variable to be binarized  - 2 unique values. Default ("default") will pick "gamma" if variables are skewed.}

\item{transform.x2}{Transform x2? Options are "default", "binary", or "gamma". "binary" will cause variable to be binarized  - 2 unique values. Default ("default") will pick "gamma"if variables are skewed.}

\item{transform.y}{Transform y? Options are "default", "binary", or "gamma". "binary" will cause variable to be binarized  - 2 unique values. Default ("default") will pick "gamma" if variables are skewed.}

\item{adjust.correlations}{If variables are skewed or binary, should correlations be adjusted so that output data has the specified correlation structure? Default is TRUE.}

\item{alpha}{The alpha. At what p-value is the interaction deemed significant? Default is 0.05.}

\item{q}{Simple slopes. How many quantiles should x2 be split into for simple slope testing? Default is 2. Simple slope testing returns the effect-size (slope) of y~x1 for the two most extreme quantiles of x2. If q=3 then the two slopes are y~x1 for the bottom 33\% of x2, and the top 33\% of x2.}

\item{cl}{Number of clusters to use for running simulations in parallel (recommended). Default is 1 (i.e. not in parallel).}

\item{ss.IQR}{Simple slope IQR. Multiplier when estimating the distribution of simple slopes within each simulation setting. Default is 1.5.}

\item{N.adjustment}{Sample size for simulations where correlation matrix is corrected to allow for skew. Default is 1,000,000}

\item{detailed_results}{Default is FALSE. Should detailed results be reported?}

\item{full_simulation}{Default is FALSE. If TRUE, will return a list that includes the full per-simulation results.}

\item{tol}{Correlation adjustment tolerance. When adjust.correlations = TRUE, correlations are adjusted so that the population correlation is within r='tol' of the target. Default = 0.005.}

\item{iter}{Max number of iterations to run the correlation adjustment for. Typically only a couple are needed. Default = 10.}
}
\value{
A data frame containing the power (\% significant results) for each unique setting combination. If full_simulation = TRUE will return a list, with one data frame that includes power, and a second that includes raw simulation results.
}
\description{
Power analysis for interaction models, by simulation. A set of n.iter simulations is run for each unique combination of model settings.
}
\examples{
power_interaction(n.iter=10, N=10,r.x1.y=0.2, r.x2.y=.2,r.x1x2.y=0.5,r.x1.x2=.2)
}
