% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InflectSSP.R
\name{InflectSSP}
\alias{InflectSSP}
\title{This function is the primary function that calls other functions in the program.}
\usage{
InflectSSP(
  Directory,
  NControl,
  NCondition,
  PSM,
  UP,
  CurveRsq,
  PValMelt,
  PValMeltFDR,
  MeltLimit,
  RunSTRING,
  STRINGScore,
  Species
)
}
\arguments{
\item{Directory}{the directory where the source data files to be analyzed are saved. This is also the location where the results will be saved.}

\item{NControl}{the number of Control replicate experiments that are to be analyzed}

\item{NCondition}{the number of Condition replicate experiments that are to be analyzed}

\item{PSM}{the number of peptide spectrum matches that are deemed acceptable for reporting}

\item{UP}{the number of unique peptides for a protein that are deemed acceptable for reporting}

\item{CurveRsq}{Coefficient of determination criteria for melt curves}

\item{PValMelt}{p-value criteria for melt shifts}

\item{PValMeltFDR}{Whether or not the FDR correction for pvalue is used in designation of melts of interest}

\item{MeltLimit}{the melt shift temperature limit used for determining which proteins to report as significant}

\item{RunSTRING}{whether or not the STRING function will be run or not in the analysis}

\item{STRINGScore}{the score to be used in the STRING analysis}

\item{Species}{species number for bioinformatics search}
}
\value{
the proteins that have significant melt shifts from an experiment
}
\description{
This function is the primary function that calls other functions in the program.
}
\examples{
\dontrun{
     Directory<-'/Users/Einstein'
     NControl<-2
     NCondition<-3
     PSM<-2
     UP<-3
     CurveRsq<-.95
     PValMelt<-0.05
     PValMeltFDR<-"No"
     MeltLimit<-3
     RunSTRING<-"Yes"
     STRINGScore<-0.99
     Species<-9606
     InflectSSP(Directory,NControl,
     NCondition,PSM,UP,CurveRsq,PValMelt,PValMeltFDR,
     MeltLimit,RunSTRING,STRINGScore,
     Species)
     }
}
