#' importIncucyteData
#'
#' Imports data exported from Incucyte Zoom software-  NEED MORE DOCUMENTATION HERE ABOUT HOW TO DO EXPORT!!
#'
#' @param filepath Path to a data file generated by the Incucyte Zoom software
#' @param metric Metric must be either pc (percent confluence) or ca (confluence area).  Default is pc.
#' @param plateid An identifier for the plate.  If set to NULL then filename used as default
#'
#' @importFrom utils head read.table write.table
#' @return IncucyteDRCPlateData object
#' @export
#'
#' @examples
#' #dataset 1
#' data_file1 <- system.file(file='extdata/example_data.txt', package='IncucyteDRC')
#' test_data1 <- importIncucyteData(data_file1, metric='pc')
#' test_data1
#' head(test_data1$data)
#'
#' #dataset 2
#' data_file2 <- system.file(file='extdata/example_data2.txt', package='IncucyteDRC')
#' test_data2 <- importIncucyteData(data_file2, metric='pc')

importIncucyteData <- function(filepath, metric='pc', plateid=basename(filepath)) {
    message(sprintf("Getting %s data for plate %s from:\n%s", metric, plateid, filepath))

    #check that the metric type is valid
    if ( !(metric %in% c('pc','ca')) ) stop('metric must be either pc (percent confluence) or ca (confluence area)')

    #do a pre-check of the data to identify the first row for the proper import - this has the string 'Date' as the first four characters
    precheck <- read.table(filepath, header=F, sep=';', as.is=T)
    start_row <- which (substr(precheck$V1,1,4) == 'Date')
    if (length (start_row) == 0 ) stop ('Please check the input data format is correct')

    data_df <- read.table(filepath,header=T,sep='\t' , stringsAsFactors=F,skip=start_row) %>%
        dplyr::rename(elapsed=Elapsed) %>%
        dplyr::select(-Date.Time) %>%
        tidyr::gather(wellid, value, -elapsed) %>%
        dplyr::mutate(wellid = as.character(wellid)) %>%
        as.data.frame()

    output <- list ( data = data_df,
                  metric = metric,
                  plateid = plateid)
    class(output) <- 'IncucyteDRCPlateData'
    return(output)



}
