% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimatePrevalence.R
\name{estimatePeriodPrevalence}
\alias{estimatePeriodPrevalence}
\title{Estimate period prevalence}
\usage{
estimatePeriodPrevalence(
  cdm,
  denominatorTable,
  outcomeTable,
  denominatorCohortId = NULL,
  outcomeCohortId = NULL,
  interval = "years",
  completeDatabaseIntervals = TRUE,
  fullContribution = FALSE,
  strata = list(),
  includeOverallStrata = TRUE,
  minCellCount = 5,
  temporary = TRUE,
  returnParticipants = FALSE
)
}
\arguments{
\item{cdm}{A CDM reference object}

\item{denominatorTable}{A cohort table with a set of denominator cohorts
(for example, created using the \code{generateDenominatorCohortSet()}
function).}

\item{outcomeTable}{A cohort table in the cdm reference containing
a set of outcome cohorts.}

\item{denominatorCohortId}{The cohort definition ids of the denominator
cohorts of interest. If NULL all cohorts will be considered in the
analysis.}

\item{outcomeCohortId}{The cohort definition ids of the outcome
cohorts of interest. If NULL all cohorts will be considered in the
analysis.}

\item{interval}{Time intervals over which period prevalence is estimated.
This can be "weeks", "months", "quarters", "years", or "overall".
ISO weeks will be used for weeks. Calendar months, quarters, or
years can be used as the period. If more than one option
is chosen then results will be estimated for each chosen interval.}

\item{completeDatabaseIntervals}{TRUE/ FALSE. Where TRUE, prevalence will
only be estimated for those intervals where the database
captures all the interval (based on the earliest and latest observation
period start dates, respectively).}

\item{fullContribution}{TRUE/ FALSE. Where TRUE, individuals will only be
included if they in the database for the entire interval of interest. If
FALSE they are only required to present for one day of the interval in
order to contribute.}

\item{strata}{Variables added to the denominator cohort table for which to
stratify estimates.}

\item{includeOverallStrata}{Whether to include an overall result as well as
strata specific results (when strata has been specified).}

\item{minCellCount}{Minimum number of events to report- results
lower than this will be obscured. If NULL all results will be reported.}

\item{temporary}{If TRUE, temporary tables will be used throughout. If
FALSE, permanent tables will be created in the write_schema of the cdm.}

\item{returnParticipants}{Either TRUE or FALSE. If TRUE references to
participants from the analysis will be returned allowing for further
analysis. Note, if using permanent tables and returnParticipants is TRUE,
one table per analysis will be kept in the cdm write schema.}
}
\value{
Period prevalence estimates
}
\description{
Estimate period prevalence
}
\examples{
\donttest{
cdm <- mockIncidencePrevalenceRef(sampleSize = 10000)
cdm <- generateDenominatorCohortSet(
  cdm = cdm, name = "denominator",
  cohortDateRange = c(as.Date("2008-01-01"), as.Date("2018-01-01"))
)
estimatePeriodPrevalence(
  cdm = cdm,
  denominatorTable = "denominator",
  outcomeTable = "outcome",
  interval = "months"
)
}
}
