/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.matrix.tfcomplex.impl.DenseLargeFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.WrapperFloatMatrix2D;
import edu.emory.mathcs.jtransforms.dct.FloatDCT_1D;
import edu.emory.mathcs.jtransforms.dct.FloatDCT_2D;
import edu.emory.mathcs.jtransforms.dht.FloatDHT_1D;
import edu.emory.mathcs.jtransforms.dht.FloatDHT_2D;
import edu.emory.mathcs.jtransforms.dst.FloatDST_1D;
import edu.emory.mathcs.jtransforms.dst.FloatDST_2D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DenseLargeFloatMatrix2D
extends WrapperFloatMatrix2D {
    private static final long serialVersionUID = 1L;
    private float[][] elements;
    private FloatFFT_2D fft2;
    private FloatDCT_2D dct2;
    private FloatDST_2D dst2;
    private FloatDHT_2D dht2;
    private FloatFFT_1D fftRows;
    private FloatFFT_1D fftColumns;
    private FloatDCT_1D dctRows;
    private FloatDCT_1D dctColumns;
    private FloatDST_1D dstRows;
    private FloatDST_1D dstColumns;
    private FloatDHT_1D dhtRows;
    private FloatDHT_1D dhtColumns;

    public DenseLargeFloatMatrix2D(int n, int n2) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = new float[n][n2];
        this.content = this;
    }

    public void dct2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dct2 == null) {
            this.dct2 = new FloatDCT_2D(this.rows, this.columns);
        }
        this.dct2.forward(this.elements, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dctColumns(final boolean bl) {
        int n;
        if (this.dctColumns == null) {
            this.dctColumns = new FloatDCT_1D(this.rows);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            float[] fArray = (float[])DenseLargeFloatMatrix2D.this.viewColumn(i).copy().elements();
                            DenseLargeFloatMatrix2D.this.dctColumns.forward(fArray, bl);
                            DenseLargeFloatMatrix2D.this.viewColumn(i).assign(fArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                float[] fArray = (float[])this.viewColumn(i).copy().elements();
                this.dctColumns.forward(fArray, bl);
                this.viewColumn(i).assign(fArray);
            }
        }
    }

    public void dctRows(final boolean bl) {
        int n;
        if (this.dctRows == null) {
            this.dctRows = new FloatDCT_1D(this.columns);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DenseLargeFloatMatrix2D.this.dctRows.forward(DenseLargeFloatMatrix2D.this.elements[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.dctRows.forward(this.elements[i], bl);
            }
        }
    }

    public void dht2() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dht2 == null) {
            this.dht2 = new FloatDHT_2D(this.rows, this.columns);
        }
        this.dht2.forward(this.elements);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dhtColumns() {
        int n;
        if (this.dhtColumns == null) {
            this.dhtColumns = new FloatDHT_1D(this.rows);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            float[] fArray = (float[])DenseLargeFloatMatrix2D.this.viewColumn(i).copy().elements();
                            DenseLargeFloatMatrix2D.this.dhtColumns.forward(fArray);
                            DenseLargeFloatMatrix2D.this.viewColumn(i).assign(fArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                float[] fArray = (float[])this.viewColumn(i).copy().elements();
                this.dhtColumns.forward(fArray);
                this.viewColumn(i).assign(fArray);
            }
        }
    }

    public void dhtRows() {
        int n;
        if (this.dhtRows == null) {
            this.dhtRows = new FloatDHT_1D(this.columns);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DenseLargeFloatMatrix2D.this.dhtRows.forward(DenseLargeFloatMatrix2D.this.elements[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.dhtRows.forward(this.elements[i]);
            }
        }
    }

    public void dst2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dst2 == null) {
            this.dst2 = new FloatDST_2D(this.rows, this.columns);
        }
        this.dst2.forward(this.elements, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dstColumns(final boolean bl) {
        int n;
        if (this.dstColumns == null) {
            this.dstColumns = new FloatDST_1D(this.rows);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            float[] fArray = (float[])DenseLargeFloatMatrix2D.this.viewColumn(i).copy().elements();
                            DenseLargeFloatMatrix2D.this.dstColumns.forward(fArray, bl);
                            DenseLargeFloatMatrix2D.this.viewColumn(i).assign(fArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                float[] fArray = (float[])this.viewColumn(i).copy().elements();
                this.dstColumns.forward(fArray, bl);
                this.viewColumn(i).assign(fArray);
            }
        }
    }

    public void dstRows(final boolean bl) {
        int n;
        if (this.dstRows == null) {
            this.dstRows = new FloatDST_1D(this.columns);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DenseLargeFloatMatrix2D.this.dstRows.forward(DenseLargeFloatMatrix2D.this.elements[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.dstRows.forward(this.elements[i], bl);
            }
        }
    }

    public void fft2() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        this.fft2.realForward(this.elements);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public DenseLargeFComplexMatrix2D getFft2() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        DenseLargeFComplexMatrix2D denseLargeFComplexMatrix2D = new DenseLargeFComplexMatrix2D(this.rows, this.columns);
        final float[][] fArray = denseLargeFComplexMatrix2D.elements();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            System.arraycopy(DenseLargeFloatMatrix2D.this.elements[i], 0, fArray[i], 0, DenseLargeFloatMatrix2D.this.columns);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                System.arraycopy(this.elements[i], 0, fArray[i], 0, this.columns);
            }
        }
        this.fft2.realForwardFull(fArray);
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseLargeFComplexMatrix2D;
    }

    public DenseLargeFComplexMatrix2D getFftColumns() {
        if (this.fftColumns == null) {
            this.fftColumns = new FloatFFT_1D(this.rows);
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseLargeFComplexMatrix2D denseLargeFComplexMatrix2D = new DenseLargeFComplexMatrix2D(this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            float[] fArray = new float[2 * DenseLargeFloatMatrix2D.this.rows];
                            System.arraycopy(DenseLargeFloatMatrix2D.this.viewColumn(i).copy().elements(), 0, fArray, 0, DenseLargeFloatMatrix2D.this.rows);
                            DenseLargeFloatMatrix2D.this.fftColumns.realForwardFull(fArray);
                            denseLargeFComplexMatrix2D.viewColumn(i).assign(fArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                float[] fArray = new float[2 * this.rows];
                System.arraycopy(this.viewColumn(i).copy().elements(), 0, fArray, 0, this.rows);
                this.fftColumns.realForwardFull(fArray);
                denseLargeFComplexMatrix2D.viewColumn(i).assign(fArray);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseLargeFComplexMatrix2D;
    }

    public DenseLargeFComplexMatrix2D getFftRows() {
        if (this.fftRows == null) {
            this.fftRows = new FloatFFT_1D(this.columns);
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseLargeFComplexMatrix2D denseLargeFComplexMatrix2D = new DenseLargeFComplexMatrix2D(this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            float[] fArray = new float[2 * DenseLargeFloatMatrix2D.this.columns];
                            System.arraycopy(DenseLargeFloatMatrix2D.this.elements[i], 0, fArray, 0, DenseLargeFloatMatrix2D.this.columns);
                            DenseLargeFloatMatrix2D.this.fftRows.realForwardFull(fArray);
                            denseLargeFComplexMatrix2D.viewRow(i).assign(fArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                float[] fArray = new float[2 * this.columns];
                System.arraycopy(this.elements[i], 0, fArray, 0, this.columns);
                this.fftRows.realForwardFull(fArray);
                denseLargeFComplexMatrix2D.viewRow(i).assign(fArray);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseLargeFComplexMatrix2D;
    }

    public DenseLargeFComplexMatrix2D getIfft2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        DenseLargeFComplexMatrix2D denseLargeFComplexMatrix2D = new DenseLargeFComplexMatrix2D(this.rows, this.columns);
        final float[][] fArray = denseLargeFComplexMatrix2D.elements();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            System.arraycopy(DenseLargeFloatMatrix2D.this.elements[i], 0, fArray[i], 0, DenseLargeFloatMatrix2D.this.columns);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                System.arraycopy(this.elements[i], 0, fArray[i], 0, this.columns);
            }
        }
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        this.fft2.realInverseFull(fArray, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseLargeFComplexMatrix2D;
    }

    public DenseLargeFComplexMatrix2D getIfftColumns(final boolean bl) {
        if (this.fftColumns == null) {
            this.fftColumns = new FloatFFT_1D(this.rows);
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseLargeFComplexMatrix2D denseLargeFComplexMatrix2D = new DenseLargeFComplexMatrix2D(this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            float[] fArray = new float[2 * DenseLargeFloatMatrix2D.this.rows];
                            System.arraycopy(DenseLargeFloatMatrix2D.this.viewColumn(i).copy().elements(), 0, fArray, 0, DenseLargeFloatMatrix2D.this.rows);
                            DenseLargeFloatMatrix2D.this.fftColumns.realInverseFull(fArray, bl);
                            denseLargeFComplexMatrix2D.viewColumn(i).assign(fArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                float[] fArray = new float[2 * this.rows];
                System.arraycopy(this.viewColumn(i).copy().elements(), 0, fArray, 0, this.rows);
                this.fftColumns.realInverseFull(fArray, bl);
                denseLargeFComplexMatrix2D.viewColumn(i).assign(fArray);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseLargeFComplexMatrix2D;
    }

    public DenseLargeFComplexMatrix2D getIfftRows(final boolean bl) {
        if (this.fftRows == null) {
            this.fftRows = new FloatFFT_1D(this.columns);
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseLargeFComplexMatrix2D denseLargeFComplexMatrix2D = new DenseLargeFComplexMatrix2D(this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            float[] fArray = new float[2 * DenseLargeFloatMatrix2D.this.columns];
                            System.arraycopy(DenseLargeFloatMatrix2D.this.elements[i], 0, fArray, 0, DenseLargeFloatMatrix2D.this.columns);
                            DenseLargeFloatMatrix2D.this.fftRows.realInverseFull(fArray, bl);
                            denseLargeFComplexMatrix2D.viewRow(i).assign(fArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                float[] fArray = new float[2 * this.columns];
                System.arraycopy(this.elements[i], 0, fArray, 0, this.columns);
                this.fftRows.realInverseFull(fArray, bl);
                denseLargeFComplexMatrix2D.viewRow(i).assign(fArray);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseLargeFComplexMatrix2D;
    }

    public float getQuick(int n, int n2) {
        return this.elements[n][n2];
    }

    public void idct2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dct2 == null) {
            this.dct2 = new FloatDCT_2D(this.rows, this.columns);
        }
        this.dct2.inverse(this.elements, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idctColumns(final boolean bl) {
        int n;
        if (this.dctColumns == null) {
            this.dctColumns = new FloatDCT_1D(this.rows);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            float[] fArray = (float[])DenseLargeFloatMatrix2D.this.viewColumn(i).copy().elements();
                            DenseLargeFloatMatrix2D.this.dctColumns.inverse(fArray, bl);
                            DenseLargeFloatMatrix2D.this.viewColumn(i).assign(fArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                float[] fArray = (float[])this.viewColumn(i).copy().elements();
                this.dctColumns.inverse(fArray, bl);
                this.viewColumn(i).assign(fArray);
            }
        }
    }

    public void idctRows(final boolean bl) {
        int n;
        if (this.dctRows == null) {
            this.dctRows = new FloatDCT_1D(this.columns);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DenseLargeFloatMatrix2D.this.dctRows.inverse(DenseLargeFloatMatrix2D.this.elements[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.dctRows.inverse(this.elements[i], bl);
            }
        }
    }

    public void idht2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dht2 == null) {
            this.dht2 = new FloatDHT_2D(this.rows, this.columns);
        }
        this.dht2.inverse(this.elements, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idhtColumns(final boolean bl) {
        int n;
        if (this.dhtColumns == null) {
            this.dhtColumns = new FloatDHT_1D(this.rows);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            float[] fArray = (float[])DenseLargeFloatMatrix2D.this.viewColumn(i).copy().elements();
                            DenseLargeFloatMatrix2D.this.dhtColumns.inverse(fArray, bl);
                            DenseLargeFloatMatrix2D.this.viewColumn(i).assign(fArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                float[] fArray = (float[])this.viewColumn(i).copy().elements();
                this.dhtColumns.inverse(fArray, bl);
                this.viewColumn(i).assign(fArray);
            }
        }
    }

    public void idhtRows(final boolean bl) {
        int n;
        if (this.dhtRows == null) {
            this.dhtRows = new FloatDHT_1D(this.columns);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DenseLargeFloatMatrix2D.this.dhtRows.inverse(DenseLargeFloatMatrix2D.this.elements[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.dhtRows.inverse(this.elements[i], bl);
            }
        }
    }

    public void idst2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dst2 == null) {
            this.dst2 = new FloatDST_2D(this.rows, this.columns);
        }
        this.dst2.inverse(this.elements, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idstColumns(final boolean bl) {
        int n;
        if (this.dstColumns == null) {
            this.dstColumns = new FloatDST_1D(this.rows);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            float[] fArray = (float[])DenseLargeFloatMatrix2D.this.viewColumn(i).copy().elements();
                            DenseLargeFloatMatrix2D.this.dstColumns.inverse(fArray, bl);
                            DenseLargeFloatMatrix2D.this.viewColumn(i).assign(fArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                float[] fArray = (float[])this.viewColumn(i).copy().elements();
                this.dstColumns.inverse(fArray, bl);
                this.viewColumn(i).assign(fArray);
            }
        }
    }

    public void idstRows(final boolean bl) {
        int n;
        if (this.dstRows == null) {
            this.dstRows = new FloatDST_1D(this.columns);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DenseLargeFloatMatrix2D.this.dstRows.inverse(DenseLargeFloatMatrix2D.this.elements[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.dstRows.inverse(this.elements[i], bl);
            }
        }
    }

    public void ifft2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        this.fft2.realInverse(this.elements, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void setQuick(int n, int n2, float f) {
        this.elements[n][n2] = f;
    }

    public float[][] elements() {
        return this.elements;
    }

    protected FloatMatrix2D getContent() {
        return this;
    }

    public FloatMatrix2D like(int n, int n2) {
        return new DenseLargeFloatMatrix2D(n, n2);
    }

    public FloatMatrix1D like1D(int n) {
        return new DenseFloatMatrix1D(n);
    }
}

