/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.Timer;
import cern.colt.function.tfcomplex.FComplexProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.BenchmarkMatrixKernel;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.jet.math.tfcomplex.FComplex;
import cern.jet.math.tfcomplex.FComplexFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.Random;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class BenchmarkDenseFComplexMatrix3D {
    private static Timer t = new Timer();
    private static final String outputFile = "BenchmarkDenseFComplexMatrix3D.txt";
    private static float[][][] a_3d;
    private static float[][][] b_3d;
    private static float[] a_1d;
    private static float[] b_1d;
    private static double[] noViewTimes;
    private static double[] viewTimes;

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{"cern.colt.matrix.tfcomplex.impl.BenchmarkDenseFComplexMatrix3D"});
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        int n;
        int n2;
        int n3;
        BenchmarkMatrixKernel.readSettings3D();
        Random random = new Random(0L);
        ConcurrencyUtils.setThreadsBeginN_3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_3D[1] * BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]);
        a_1d = new float[2 * BenchmarkMatrixKernel.MATRIX_SIZE_3D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_3D[1] * BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]];
        a_3d = new float[BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]][BenchmarkMatrixKernel.MATRIX_SIZE_3D[1]][2 * BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]];
        int n4 = 0;
        for (n3 = 0; n3 < BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]; ++n3) {
            for (n2 = 0; n2 < BenchmarkMatrixKernel.MATRIX_SIZE_3D[1]; ++n2) {
                for (n = 0; n < 2 * BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]; ++n) {
                    BenchmarkDenseFComplexMatrix3D.a_3d[n3][n2][n] = random.nextFloat();
                    BenchmarkDenseFComplexMatrix3D.a_1d[n4++] = a_3d[n3][n2][n];
                }
            }
        }
        b_1d = new float[2 * BenchmarkMatrixKernel.MATRIX_SIZE_3D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_3D[1] * BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]];
        b_3d = new float[BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]][BenchmarkMatrixKernel.MATRIX_SIZE_3D[1]][2 * BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]];
        n4 = 0;
        for (n3 = 0; n3 < BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]; ++n3) {
            for (n2 = 0; n2 < BenchmarkMatrixKernel.MATRIX_SIZE_3D[1]; ++n2) {
                for (n = 0; n < 2 * BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]; ++n) {
                    BenchmarkDenseFComplexMatrix3D.b_3d[n3][n2][n] = random.nextFloat();
                    BenchmarkDenseFComplexMatrix3D.b_1d[n4++] = b_3d[n3][n2][n];
                }
            }
        }
        BenchmarkMatrixKernel.writePropertiesToFile(outputFile, BenchmarkMatrixKernel.MATRIX_SIZE_3D);
        BenchmarkMatrixKernel.displayProperties(BenchmarkMatrixKernel.MATRIX_SIZE_3D);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        a_1d = null;
        a_3d = null;
        b_1d = null;
        b_3d = null;
        ConcurrencyUtils.resetThreadsBeginN();
        System.gc();
    }

    @Before
    public void setUpBefore() {
        noViewTimes = new double[BenchmarkMatrixKernel.NTHREADS.length];
        viewTimes = new double[BenchmarkMatrixKernel.NTHREADS.length];
    }

    @Test
    public void testAggregateFComplexFComplexFComplexFunctionFComplexFComplexFunction() {
        DenseFComplexMatrix3D denseFComplexMatrix3D = new DenseFComplexMatrix3D(a_3d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float[] fArray = ((FComplexMatrix3D)denseFComplexMatrix3D).aggregate(FComplexFunctions.plus, FComplexFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = ((FComplexMatrix3D)denseFComplexMatrix3D).aggregate(FComplexFunctions.plus, FComplexFunctions.square);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix3D fComplexMatrix3D = new DenseFComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            float[] fArray = fComplexMatrix3D.aggregate(FComplexFunctions.plus, FComplexFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = fComplexMatrix3D.aggregate(FComplexFunctions.plus, FComplexFunctions.square);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "aggregate(FComplexFComplexFComplexFunction, FComplexFComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAggregateFComplexMatrix3DFComplexFComplexFComplexFunctionFComplexFComplexFComplexFunction() {
        int n;
        Object object;
        DenseFComplexMatrix3D denseFComplexMatrix3D = new DenseFComplexMatrix3D(a_3d);
        DenseFComplexMatrix3D denseFComplexMatrix3D2 = new DenseFComplexMatrix3D(b_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            object = ((FComplexMatrix3D)denseFComplexMatrix3D).aggregate(denseFComplexMatrix3D2, FComplexFunctions.plus, FComplexFunctions.mult);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                t.reset().start();
                object = ((FComplexMatrix3D)denseFComplexMatrix3D).aggregate(denseFComplexMatrix3D2, FComplexFunctions.plus, FComplexFunctions.mult);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix3D fComplexMatrix3D = new DenseFComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        object = new DenseFComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(b_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float[] fArray = fComplexMatrix3D.aggregate((FComplexMatrix3D)object, FComplexFunctions.plus, FComplexFunctions.mult);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = fComplexMatrix3D.aggregate((FComplexMatrix3D)object, FComplexFunctions.plus, FComplexFunctions.mult);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "aggregate(FComplexMatrix3D, FComplexFComplexFComplexFunction, FComplexFComplexFComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloatFloat() {
        int n;
        DenseFComplexMatrix3D denseFComplexMatrix3D = new DenseFComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[0], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]);
        float f = (float)Math.random();
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FComplexMatrix3D)denseFComplexMatrix3D).assign(f, f);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FComplexMatrix3D)denseFComplexMatrix3D).assign(0.0f, 0.0f);
                t.reset().start();
                ((FComplexMatrix3D)denseFComplexMatrix3D).assign(f, f);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix3D fComplexMatrix3D = new DenseFComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            fComplexMatrix3D.assign(f, f);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix3D.assign(0.0f, 0.0f);
                t.reset().start();
                fComplexMatrix3D.assign(f, f);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(float, float)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloatArray() {
        int n;
        DenseFComplexMatrix3D denseFComplexMatrix3D = new DenseFComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[0], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FComplexMatrix3D)denseFComplexMatrix3D).assign(a_1d);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FComplexMatrix3D)denseFComplexMatrix3D).assign(0.0f, 0.0f);
                t.reset().start();
                ((FComplexMatrix3D)denseFComplexMatrix3D).assign(a_1d);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix3D fComplexMatrix3D = new DenseFComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            fComplexMatrix3D.assign(a_1d);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix3D.assign(0.0f, 0.0f);
                t.reset().start();
                fComplexMatrix3D.assign(a_1d);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(float[])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloatArrayArrayArray() {
        int n;
        DenseFComplexMatrix3D denseFComplexMatrix3D = new DenseFComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[0], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FComplexMatrix3D)denseFComplexMatrix3D).assign(a_3d);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FComplexMatrix3D)denseFComplexMatrix3D).assign(0.0f, 0.0f);
                t.reset().start();
                ((FComplexMatrix3D)denseFComplexMatrix3D).assign(a_3d);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix3D fComplexMatrix3D = new DenseFComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            fComplexMatrix3D.assign(a_3d);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix3D.assign(0.0f, 0.0f);
                t.reset().start();
                fComplexMatrix3D.assign(a_3d);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(float[][][])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFComplexFComplexFunction() {
        int n;
        DenseFComplexMatrix3D denseFComplexMatrix3D = new DenseFComplexMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FComplexMatrix3D)denseFComplexMatrix3D).assign(FComplexFunctions.acos);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FComplexMatrix3D)denseFComplexMatrix3D).assign(a_3d);
                t.reset().start();
                ((FComplexMatrix3D)denseFComplexMatrix3D).assign(FComplexFunctions.acos);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix3D fComplexMatrix3D = new DenseFComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            fComplexMatrix3D.assign(FComplexFunctions.acos);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix3D.assign(a_3d);
                t.reset().start();
                fComplexMatrix3D.assign(FComplexFunctions.acos);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(FComplexFComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFComplexMatrix3D() {
        DenseFComplexMatrix3D denseFComplexMatrix3D = new DenseFComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[0], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]);
        DenseFComplexMatrix3D denseFComplexMatrix3D2 = new DenseFComplexMatrix3D(a_3d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((FComplexMatrix3D)denseFComplexMatrix3D).assign(denseFComplexMatrix3D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((FComplexMatrix3D)denseFComplexMatrix3D).assign(0.0f, 0.0f);
                t.reset().start();
                ((FComplexMatrix3D)denseFComplexMatrix3D).assign(denseFComplexMatrix3D2);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseFComplexMatrix3D = new DenseFComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[0], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]);
        FComplexMatrix3D fComplexMatrix3D = denseFComplexMatrix3D.viewDice(2, 1, 0);
        denseFComplexMatrix3D2 = new DenseFComplexMatrix3D(a_3d);
        FComplexMatrix3D fComplexMatrix3D2 = denseFComplexMatrix3D2.viewDice(2, 1, 0);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            fComplexMatrix3D.assign(fComplexMatrix3D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix3D.assign(0.0f, 0.0f);
                t.reset().start();
                fComplexMatrix3D.assign(fComplexMatrix3D2);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(FComplexMatrix3D)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFComplexMatrix3DFComplexFComplexFComplexFunction() {
        DenseFComplexMatrix3D denseFComplexMatrix3D = new DenseFComplexMatrix3D(a_3d);
        DenseFComplexMatrix3D denseFComplexMatrix3D2 = new DenseFComplexMatrix3D(b_3d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((FComplexMatrix3D)denseFComplexMatrix3D).assign(denseFComplexMatrix3D2, FComplexFunctions.div);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((FComplexMatrix3D)denseFComplexMatrix3D).assign(a_3d);
                t.reset().start();
                ((FComplexMatrix3D)denseFComplexMatrix3D).assign(denseFComplexMatrix3D2, FComplexFunctions.div);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix3D fComplexMatrix3D = new DenseFComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        FComplexMatrix3D fComplexMatrix3D2 = new DenseFComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(b_3d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            fComplexMatrix3D.assign(fComplexMatrix3D2, FComplexFunctions.div);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix3D.assign(a_3d);
                t.reset().start();
                fComplexMatrix3D.assign(fComplexMatrix3D2, FComplexFunctions.div);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(FComplexMatrix3D, FComplexFComplexFComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFComplexProcedureFloatArray() {
        int n;
        DenseFComplexMatrix3D denseFComplexMatrix3D = new DenseFComplexMatrix3D(a_3d);
        float[] fArray = new float[]{-1.0f, -2.0f};
        FComplexProcedure fComplexProcedure = new FComplexProcedure(){

            public boolean apply(float[] fArray) {
                return (double)FComplex.abs(fArray) > 0.1;
            }
        };
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FComplexMatrix3D)denseFComplexMatrix3D).assign(fComplexProcedure, fArray);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FComplexMatrix3D)denseFComplexMatrix3D).assign(a_3d);
                t.reset().start();
                ((FComplexMatrix3D)denseFComplexMatrix3D).assign(fComplexProcedure, fArray);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix3D fComplexMatrix3D = new DenseFComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            fComplexMatrix3D.assign(fComplexProcedure, fArray);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix3D.assign(a_3d);
                t.reset().start();
                fComplexMatrix3D.assign(fComplexProcedure, fArray);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(FComplexProcedure, float[])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFComplexProcedureFComplexFComplexFunction() {
        int n;
        DenseFComplexMatrix3D denseFComplexMatrix3D = new DenseFComplexMatrix3D(a_3d);
        FComplexProcedure fComplexProcedure = new FComplexProcedure(){

            public boolean apply(float[] fArray) {
                return (double)FComplex.abs(fArray) > 0.1;
            }
        };
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FComplexMatrix3D)denseFComplexMatrix3D).assign(fComplexProcedure, FComplexFunctions.tan);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FComplexMatrix3D)denseFComplexMatrix3D).assign(a_3d);
                t.reset().start();
                ((FComplexMatrix3D)denseFComplexMatrix3D).assign(fComplexProcedure, FComplexFunctions.tan);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix3D fComplexMatrix3D = new DenseFComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            fComplexMatrix3D.assign(fComplexProcedure, FComplexFunctions.tan);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix3D.assign(a_3d);
                t.reset().start();
                fComplexMatrix3D.assign(fComplexProcedure, FComplexFunctions.tan);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(FComplexProcedure, FComplexFComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testCardinality() {
        int n;
        int n2;
        DenseFComplexMatrix3D denseFComplexMatrix3D = new DenseFComplexMatrix3D(a_3d);
        int n3 = 0;
        while (n3 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n3]);
            n2 = ((FComplexMatrix3D)denseFComplexMatrix3D).cardinality();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                t.reset().start();
                n2 = ((FComplexMatrix3D)denseFComplexMatrix3D).cardinality();
                t.stop();
                int n4 = n3;
                noViewTimes[n4] = noViewTimes[n4] + t.millis();
            }
            int n5 = n3++;
            noViewTimes[n5] = noViewTimes[n5] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseFComplexMatrix3D = new DenseFComplexMatrix3D(a_3d);
        FComplexMatrix3D fComplexMatrix3D = denseFComplexMatrix3D.viewDice(2, 1, 0);
        n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            n = fComplexMatrix3D.cardinality();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                n = fComplexMatrix3D.cardinality();
                t.stop();
                int n6 = n2;
                viewTimes[n6] = viewTimes[n6] + t.millis();
            }
            int n7 = n2++;
            viewTimes[n7] = viewTimes[n7] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "cardinality()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testFft3() {
        int n;
        DenseFComplexMatrix3D denseFComplexMatrix3D = new DenseFComplexMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFComplexMatrix3D.fft3();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFComplexMatrix3D.assign(a_3d);
                t.reset().start();
                denseFComplexMatrix3D.fft3();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix3D fComplexMatrix3D = new DenseFComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFComplexMatrix3D)fComplexMatrix3D).fft3();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix3D.assign(a_3d);
                t.reset().start();
                ((DenseFComplexMatrix3D)fComplexMatrix3D).fft3();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "fft3()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testFft2Slices() {
        int n;
        DenseFComplexMatrix3D denseFComplexMatrix3D = new DenseFComplexMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFComplexMatrix3D.fft2Slices();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFComplexMatrix3D.assign(a_3d);
                t.reset().start();
                denseFComplexMatrix3D.fft2Slices();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix3D fComplexMatrix3D = new DenseFComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFComplexMatrix3D)fComplexMatrix3D).fft2Slices();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix3D.assign(a_3d);
                t.reset().start();
                ((DenseFComplexMatrix3D)fComplexMatrix3D).fft2Slices();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "fft2Slices()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetRealPart() {
        DenseFComplexMatrix3D denseFComplexMatrix3D = new DenseFComplexMatrix3D(a_3d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            FloatMatrix3D floatMatrix3D = ((FComplexMatrix3D)denseFComplexMatrix3D).getRealPart();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                floatMatrix3D = ((FComplexMatrix3D)denseFComplexMatrix3D).getRealPart();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix3D fComplexMatrix3D = new DenseFComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            FloatMatrix3D floatMatrix3D = fComplexMatrix3D.getRealPart();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                floatMatrix3D = fComplexMatrix3D.getRealPart();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getRealPart()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetImaginaryPart() {
        DenseFComplexMatrix3D denseFComplexMatrix3D = new DenseFComplexMatrix3D(a_3d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            FloatMatrix3D floatMatrix3D = ((FComplexMatrix3D)denseFComplexMatrix3D).getImaginaryPart();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                floatMatrix3D = ((FComplexMatrix3D)denseFComplexMatrix3D).getImaginaryPart();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix3D fComplexMatrix3D = new DenseFComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            FloatMatrix3D floatMatrix3D = fComplexMatrix3D.getImaginaryPart();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                floatMatrix3D = fComplexMatrix3D.getImaginaryPart();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getImaginaryPart()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetNonZerosIntArrayListIntArrayListIntArrayListArrayList() {
        int n;
        DenseFComplexMatrix3D denseFComplexMatrix3D = new DenseFComplexMatrix3D(a_3d);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FComplexMatrix3D)denseFComplexMatrix3D).getNonZeros(intArrayList, intArrayList2, intArrayList3, arrayList);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                intArrayList.clear();
                intArrayList2.clear();
                intArrayList3.clear();
                arrayList.clear();
                t.reset().start();
                ((FComplexMatrix3D)denseFComplexMatrix3D).getNonZeros(intArrayList, intArrayList2, intArrayList3, arrayList);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix3D fComplexMatrix3D = new DenseFComplexMatrix3D(a_3d).viewDice(2, 1, 0);
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        arrayList.clear();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            fComplexMatrix3D.getNonZeros(intArrayList, intArrayList2, intArrayList3, arrayList);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                intArrayList.clear();
                intArrayList2.clear();
                intArrayList3.clear();
                arrayList.clear();
                t.reset().start();
                fComplexMatrix3D.getNonZeros(intArrayList, intArrayList2, intArrayList3, arrayList);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getNonZeros(IntArrayList, IntArrayList, IntArrayList, ArrayList)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIfft3() {
        int n;
        DenseFComplexMatrix3D denseFComplexMatrix3D = new DenseFComplexMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFComplexMatrix3D.ifft3(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFComplexMatrix3D.assign(a_3d);
                t.reset().start();
                denseFComplexMatrix3D.ifft3(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix3D fComplexMatrix3D = new DenseFComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFComplexMatrix3D)fComplexMatrix3D).ifft3(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix3D.assign(a_3d);
                t.reset().start();
                ((DenseFComplexMatrix3D)fComplexMatrix3D).ifft3(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "ifft3(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIfft2Slices() {
        int n;
        DenseFComplexMatrix3D denseFComplexMatrix3D = new DenseFComplexMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFComplexMatrix3D.ifft2Slices(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFComplexMatrix3D.assign(a_3d);
                t.reset().start();
                denseFComplexMatrix3D.ifft2Slices(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix3D fComplexMatrix3D = new DenseFComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFComplexMatrix3D)fComplexMatrix3D).ifft2Slices(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix3D.assign(a_3d);
                t.reset().start();
                ((DenseFComplexMatrix3D)fComplexMatrix3D).ifft2Slices(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "ifft2Slices(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testSum() {
        DenseFComplexMatrix3D denseFComplexMatrix3D = new DenseFComplexMatrix3D(a_3d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float[] fArray = ((FComplexMatrix3D)denseFComplexMatrix3D).zSum();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = ((FComplexMatrix3D)denseFComplexMatrix3D).zSum();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix3D fComplexMatrix3D = new DenseFComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            float[] fArray = fComplexMatrix3D.zSum();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = fComplexMatrix3D.zSum();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "zSum()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testToArray() {
        DenseFComplexMatrix3D denseFComplexMatrix3D = new DenseFComplexMatrix3D(a_3d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float[][][] fArray = ((FComplexMatrix3D)denseFComplexMatrix3D).toArray();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = ((FComplexMatrix3D)denseFComplexMatrix3D).toArray();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix3D fComplexMatrix3D = new DenseFComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            float[][][] fArray = fComplexMatrix3D.toArray();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = fComplexMatrix3D.toArray();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "toArray()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testVectorize() {
        DenseFComplexMatrix3D denseFComplexMatrix3D = new DenseFComplexMatrix3D(a_3d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            FComplexMatrix1D fComplexMatrix1D = ((FComplexMatrix3D)denseFComplexMatrix3D).vectorize();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fComplexMatrix1D = ((FComplexMatrix3D)denseFComplexMatrix3D).vectorize();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix3D fComplexMatrix3D = new DenseFComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            FComplexMatrix1D fComplexMatrix1D = fComplexMatrix3D.vectorize();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fComplexMatrix1D = fComplexMatrix3D.vectorize();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "vectorize()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }
}

