% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one.Immigrate.R
\name{one.Immigrate}
\alias{one.Immigrate}
\title{one.Immigrate}
\usage{
one.Immigrate(train_xx, train_yy, W, sig = 1)
}
\arguments{
\item{train_xx}{model matrix of explanatory variables}

\item{train_yy}{label vector}

\item{W}{initial weight matrix}

\item{sig}{sigma used in algorithm, default to be 1}
}
\value{
\item{W}{new weight matrix after one loop}

\item{C}{ cost after one loop}
}
\description{
This function performs Immigrate(Iterative Max-Min Entropy Margin-Maximization with Interaction Terms) algorithm for one loop.
}
\examples{
data(park)
xx<-park$xx
yy<-park$yy
W0 <- diag(rep(1,ncol(xx)),ncol(xx))/sqrt(ncol(xx))
re<-one.Immigrate(xx,yy,W0)
print(re$w)

}
\keyword{Immigrate}
\keyword{one}
