% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mission_orbits.R
\name{vsi_kml_from_zip}
\alias{vsi_kml_from_zip}
\title{Utilizing Virtual File Systems (vsi) to extract the .kml from the .zip file}
\usage{
vsi_kml_from_zip(
  icesat_rgt_url,
  download_zip = FALSE,
  download_method = "curl",
  verbose = FALSE
)
}
\arguments{
\item{icesat_rgt_url}{a character string specifying the input .zip URL}

\item{download_zip}{a boolean. If TRUE the .zip file will be first downloaded and then the .kml files will be returned, otherwise the 'gdalinfo' function will be used as input to the R 'system2()' function to read the .kml files without downloading the .zip file. The 'gdalinfo' command requires that the user has configured GDAL properly.}

\item{download_method}{a character string specifying the download method. Corresponds to the 'method' parameter of the 'utils::download.file()' function. Can be one of 'internal', 'wininet' (Windows only), 'libcurl', 'wget', 'curl' or 'auto'}

\item{verbose}{a boolean. If TRUE then information will be printed out in the console}
}
\value{
an one column data.table of the output files
}
\description{
Utilizing Virtual File Systems (vsi) to extract the .kml from the .zip file
}
\examples{

\dontrun{

require(IceSat2R)

URL = 'https://icesat-2.gsfc.nasa.gov/sites/default/files/page_files/arcticallorbits.zip'

#..................................
# without downloading the .zip file
#..................................

res_out = vsi_kml_from_zip(icesat_rgt_url = URL,
                           download_zip = FALSE,
                           download_method = 'curl',
                           verbose = TRUE)
str(res_out)


#.............................
# by downloading the .zip file
#.............................

res_out = vsi_kml_from_zip(icesat_rgt_url = URL,
                           download_zip = TRUE,
                           download_method = 'curl',
                           verbose = TRUE)
str(res_out)

}
}
\references{
https://icesat-2.gsfc.nasa.gov/science/specs

https://gdal.org/user/virtual_file_systems.html
}
