% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mission_orbits.R
\name{available_RGTs}
\alias{available_RGTs}
\title{Reference Ground Tracks (RGTs)}
\usage{
available_RGTs(only_cycle_names = FALSE)
}
\arguments{
\item{only_cycle_names}{a boolean. If TRUE then only the RGT (Reference Ground Track) cycle names will be returned. Otherwise all orbit files, dates and cycle names.}
}
\value{
a list object with the available orbit files, dates and cycle names
}
\description{
Reference Ground Tracks (RGTs)
}
\examples{

require(IceSat2R)

#.................................................
# all available orbit files, dates and cycle names
#.................................................

avail_dat = available_RGTs(only_cycle_names = FALSE)
avail_dat

#.............................
# receive only the cycle names
#.............................

avail_cycles = available_RGTs(only_cycle_names = TRUE)
avail_cycles
}
\references{
https://icesat-2.gsfc.nasa.gov/science/specs
}
