% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dt_gen.R
\name{sim_panelGVAR}
\alias{sim_panelGVAR}
\title{Simulate data for a (multi-group) panelGVAR model}
\usage{
sim_panelGVAR(
  temp_base_ls,
  beta_base_ls,
  cont_base_ls,
  n_node,
  n_person = 500,
  n_time = 3,
  n_group,
  mean_trend = 0,
  p_rewire_temp = 0,
  p_rewire_cont = 0,
  save_nets = FALSE
)
}
\arguments{
\item{temp_base_ls}{a list of temporal networks of all groups}

\item{beta_base_ls}{a list of beta matrices of all groups}

\item{cont_base_ls}{a list of contemporaneous networks of all groups}

\item{n_node}{number of nodes}

\item{n_person}{an integer denoting the sample size of each group, default to 500}

\item{n_time}{number of waves, default to 3}

\item{n_group}{number of groups}

\item{mean_trend}{a numeric value indicating the extent of mean trends in data, default to 0}

\item{p_rewire_temp}{a numeric value between 0 and 1 indicating the extent of non-stationarity in temporal networks, default to 0}

\item{p_rewire_cont}{a numeric value between 0 and 1 indicating the extent of non-stationarity in contemporaneous networks, default to 0}

\item{save_nets}{a logical value indicating whether to save the data-generating networks, default to FALSE}
}
\value{
A list of temporal and contemporaneous networks
}
\description{
This function generates data for the input (multi-group) panelGVAR model
}
\examples{
library(IVPP)
# Generate the network
net_ls <- gen_panelGVAR(n_node = 6,
                        p_rewire = 0.5,
                        n_group = 3)

# Generate the data
data <- sim_panelGVAR(temp_base_ls = net_ls$temporal,
                      cont_base_ls = net_ls$omega_zeta_within,
                      n_person = 500,
                      n_time = 4,
                      n_group = 3,
                      n_node = 6)
}
