% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dag_test_FS.R
\name{dag_test_FS}
\alias{dag_test_FS}
\title{dag_test_FS}
\usage{
dag_test_FS(X0, p, alpha)
}
\arguments{
\item{X0}{a numeric vector or matrix with one column giving points corresponding to hypotheses.}

\item{p}{a numeric vector taking values in (0, 1] such that \code{length(p) == nrow(X0)} if X0 is a matrix (or \code{length(p) == length(X0)} if X0 is a numeric vector).}

\item{alpha}{a numeric value in (0, 1] specifying the Type I error rate.}
}
\value{
A boolean vector of the same length as \code{p} with each element being \code{TRUE} if the corresponding hypothesis is rejected and \code{FALSE} otherwise.
}
\description{
Implements the fixed sequence testing procedure of familywise error rate control. The sequence is given through ordering elements of \code{X0} decreasingly.
}
\examples{
X0 <- c(0.5, 0, 1)
p <- c(0.01, 0.1, 0.05)
alpha <- 0.05
dag_test_FS(X0, p, alpha)

}
