\name{rotate2D}

\alias{rotate2D}


\title{Rotate horiztonal components of a seismic signal}

\description{
The rotate2D() function rotates the two horizontal components of a
seismic signal into Radial and Transverse compoents returned as a list of 2 \code{Stream} objects.
}

\usage{
rotate2D(st1, st2, angle)
}

\arguments{
  \item{st1}{horizontal ('N' or '1') \code{Stream} from a channel set}
  \item{st2}{horizontal ('E' or '2') \code{Stream} from a channel set}
  \item{angle}{angle (degrees) of the rotation}
}

\details{
The \code{rotation} web service returns Radial and Transverse seismic Streams, generated by
rotating \code{st1} and \code{st2} by \code{angle} degrees.

The rotation service uses the following transformation matrix to change the output vectors for 2-D horizontal transformations

\deqn{ M_{2D} = \left[ \begin{array}{cc} cos \alpha & sin \alpha \cr -sin \alpha & cos \alpha \end{array} \right] }

\deqn{ \left[ \begin{array}{c} R \cr T \end{array} \right] = M_{2D} \left[ \begin{array}{c} N \cr E \end{array} \right] }

where :

 N and E represent data from the original (horizontal) orientations
 R and T represent the Radial and Transverse components.
 \eqn{\alpha} is the azimuth angle measured clockwise from north
}

\value{
A list of two \code{Stream} objects \code{stR} and \code{stT} is returned.
}

\references{
%% ~put references to the literature/web site here ~
IRIS DMC rotation web service documentation:

  \url{http://service.iris.edu/irisws/rotation/docs/1/help/}
}

\author{
Jonathan Callahan \email{jonathan.s.callahan@gmail.com}
}

%% \note{ }

%% ~Make other sections like Warning with \section{Warning }{....} ~

%% \seealso{ }

%% \examples{ }

