% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_chart.R
\name{item_chart}
\alias{item_chart}
\title{Item Chart}
\usage{
item_chart(
  data,
  file_name = "none",
  size = 1,
  font = "sans",
  rotate_radians = 0,
  rotate_degrees = 0,
  file_width = 12,
  file_height = 10,
  dpi = 500,
  color = "black",
  color2 = "black",
  fade_axes = 50,
  fade_grid_major = 15,
  fade_grid_minor = 65,
  dodge = 1,
  dist_test_label = 0.5,
  rotate_test_label_radians = 0,
  rotate_test_label_degrees = 0,
  width_items = 1,
  length_items = 1,
  length_ratio_items = 1.5,
  size_tick_label = 1,
  size_test_label = 1,
  size_facet_labels = 1,
  width_axes = 1,
  size_arrow_heads = 1,
  width_grid = 1
)
}
\arguments{
\item{data}{SEM estimates in the appropriate format, given by the input
functions.}

\item{file_name}{character; name of the file to save. Supported formats are:
"pdf" (highest quality and smallest file size), "png", "jpeg"; defaults to "none".}

\item{size}{integer; changes the size of most chart objects simultaneously.}

\item{font}{character; text font, use extrafonts to access additional fonts;
defaults to "sans", which is "Helvetica".}

\item{rotate_radians}{integer; radian angle to rotate the chart
counter-clockwise by; use fractions of pi (e.g. pi/2 = 90 degrees).}

\item{rotate_degrees}{integer; angle in degrees to rotate the chart
counter-clockwise by.}

\item{file_width}{integer; file width in inches; defaults to 12.}

\item{file_height}{integer; file height in inches; defaults to 10.}

\item{dpi}{integer; resolution in dots per inch for "png" and "jpeg" files;
defaults to 500.}

\item{color}{first accent color; defaults to "black".}

\item{color2}{second accent color; defaults to "black".}

\item{fade_axes}{integer; brightness of the gray tone of the axes between 0 =
"black" and 100 = "white" in steps of 1; defaults to 50.}

\item{fade_grid_major}{integer; brightness of the gray tone of the major grid
lines between 0 = "black" and 100 = "white" in steps of 1; defaults to 15.}

\item{fade_grid_minor}{integer; brightness of the gray tone of the minor grid
lines between 0 = "black" and 100 = "white" in steps of 1; defaults to 65.}

\item{dodge}{integer; horizontal outward dodge of facet labels relative to
default.}

\item{dist_test_label}{integer; position of the test label relative to the
surrounding circle; defaults to .5, in which case the test label is
displayed halfway from the center to the surrounding circle.}

\item{rotate_test_label_radians}{integer; radian angle to rotate the test
label counter-clockwise by; use fractions of pi (e.g. pi/2 = 90 degrees).}

\item{rotate_test_label_degrees}{integer; angle in degrees to rotate the test
label counter-clockwise by.}

\item{width_items}{integer; item bar width relative to default.}

\item{length_items}{integer; item bar length relative to default.}

\item{length_ratio_items}{integer; relative item bar length; defaults to 1.5.}

\item{size_tick_label}{integer; axis tick label font size relative to
default.}

\item{size_test_label}{integer; test label font size relative to default.}

\item{size_facet_labels}{integer; facet label font size relative to default.}

\item{width_axes}{integer; radial axis width relative to default.}

\item{size_arrow_heads}{integer; arrow head size relative to default.}

\item{width_grid}{integer; grid line width relative to default.}
}
\value{
Object of the class "ggplot" and, by default, the same object saved
  as a file.
}
\description{
Creates an item chart, showing the items of a test arranged by facets.
}
\details{
When changing the size of objects, consider the \code{size}
  parameter first and make specific adjustments with the other \code{size_}
  and \code{width_} parameters after.

  To better display overlapping item values, change the width of the item
  bars, or set the accent colors to different values, or change the ratio of
  item lengths.

  Pdf files will be vector based and can be scaled arbitrarily. For other
  formats use \code{file_width}, \code{file_height}, and \code{dpi} to avoid
  later rescaling and loss of quality.
}
\examples{
# as simple as that
item_chart(SMTQ)

}
\seealso{
\code{\link{facet_chart}} \code{\link{nested_chart}}
}
