% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_classes.R, R/cgeneric.R
\docType{class}
\name{cgeneric-class}
\alias{cgeneric-class}
\alias{cgeneric.default}
\alias{cgeneric.character}
\title{A \code{cgeneric} model described in \code{\link[=cgeneric]{cgeneric()}}.}
\usage{
\method{cgeneric}{default}(model, debug = FALSE, useINLAprecomp = TRUE, libpath = NULL, ...)

\method{cgeneric}{character}(model, ...)
}
\arguments{
\item{model}{object class for what a \code{cgeneric} method exists.
E.g., if it is a character, a specific function will be called:
cgeneric("iid", ...") calls cgeneric_iid(...)}

\item{debug}{integer, default is zero, indicating the verbose level.
Will be used as logical by INLA.}

\item{useINLAprecomp}{logical, default is TRUE, indicating if it is to
be used the shared object pre-compiled by INLA.
This is not considered if 'libpath' is provided.}

\item{libpath}{string, default is NULL, with the path to the shared object.}

\item{...}{additional arguments passed on to methods}
}
\description{
A \code{cgeneric} model described in \code{\link[=cgeneric]{cgeneric()}}.
}
\section{Functions}{
\itemize{
\item \code{cgeneric(default)}: This calls \code{\link[INLA:cgeneric]{INLA::inla.cgeneric.define()}}

\item \code{cgeneric(character)}: Method for when \code{model} is a character.
E.g. cgeneric(model = "generic0")
calls \link{cgeneric_generic0}

}}
