% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INCA.MAPlot.R
\name{INCA.MAPlot}
\alias{INCA.MAPlot}
\title{MA Plot for Array data, with optional highlighting of set of genes}
\usage{
INCA.MAPlot(x, wcol, spikeIn = TRUE, SpikeFile, prefix = "",
  highlight = NULL)
}
\arguments{
\item{x}{an RGList object}

\item{wcol}{an integer specifying the number of the column where Gene Names can be found in the gene annotation table.}

\item{spikeIn}{logical, TRUE to highlight SpikeIn Probes. Requires input in SpikeFile.}

\item{SpikeFile}{a data.frame specifying the Spike In probe names if spikeIn=TRUE in a column called "Probe" and the expected relative amounts for each dye, respectively in a "Cy5" and "Cy3" column. For example, a given probe might be expected in a 3:1 ratio thus column "Cy5" would specify 3 and column "Cy3" would specify 1.}

\item{prefix}{a character specifying the prefix to be used when saving the plot in a jpeg file.}

\item{highlight}{a character vector specifying a set of genes of interest to be highlighted in the plot.}
}
\value{
Generates jpeg files of MA plots for each arrays.
}
\description{
Plots MA plot for microarray data and highlights sets of genes and/or SpikeIn probes.
}
\examples{
#Load the INCATome Dataset
data(INCATomeData)
attach(INCATomeData)
INCA.MAPlot(RGdata,8,spikeIn=TRUE,SpikeFile=sdata, highlight=c("ACTB","PABPC1"))
}
