% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FullConditionals.R
\name{Procrustes}
\alias{Procrustes}
\title{Procrustes Transformation}
\usage{
Procrustes(X,
           Xstar,
           translate = FALSE,
           dilate = FALSE,
           sumsq = FALSE)
}
\arguments{
\item{X}{The matrix to be transformed.}

\item{Xstar}{The target matrix.}

\item{translate}{Logical value indicating whether \code{X} should be translated (defaults to \code{FALSE}).}

\item{dilate}{Logical value indicating whether \code{X} should be dilated (defaults to \code{FALSE}).}

\item{sumsq}{Logical value indicating whether the sum of squared differences between \code{X} and \code{Xstar} should be calculated and returned.}
}
\value{
A list containing:
\item{X.new}{The matrix that is the Procrustes transformed version of \code{X}.}
\item{R}{The rotation matrix.}
\item{t}{The translation vector (if \code{isTRUE(translate)}).}
\item{d}{The scaling factor (is \code{isTRUE(dilate)}).}
\item{ss}{The sum of squared differences (if \code{isTRUE(sumsq)}).}
}
\description{
This function performs a Procrustes transformation on a matrix \code{X} to minimize the squared distance between \code{X} and another comparable matrix \code{Xstar}.
}
\details{
{
   \code{R}, \code{tt}, and \code{d} are chosen so that:

   \deqn{d \times \mathbf{X} \mathbf{R} + 1\hspace*{-3.5pt}1 \underline{t}^\top \approx X^\star}{d X R + 1 t' approximately Xstar}

   \code{X.new} is given by:

   \deqn{X_{\textrm{new}} = d \times \mathbf{X} \mathbf{R} + 1\hspace*{-3.5pt}1 \underline{t}^\top}{X.new = d X R + 1 t'}
}
}
\note{
\code{X} is padded out with columns containing \code{0} if it has fewer columns than \code{Xstar}.
}
\examples{
# Match two matrices, allowing translation and dilation
mat1     <- diag(rnorm(10))
mat2     <- 0.05 * matrix(rnorm(100), 10, 10) + mat1
proc     <- Procrustes(X=mat1, Xstar=mat2, translate=TRUE, dilate=TRUE, sumsq=TRUE)

# Extract the transformed matrix, rotation matrix, translation vector and scaling factor
mat_new  <- proc$X.new
mat_rot  <- proc$R
mat_t    <- proc$t
mat_d    <- proc$d

# Compare the sum of squared differences to a Procrustean transformation with rotation only
mat_ss   <- proc$ss
mat_ss2  <- Procrustes(X=mat1, Xstar=mat2, sumsq=TRUE)$ss
}
\references{
Borg, I. and Groenen, P. J. F. (1997) \emph{Modern Multidimensional Scaling}. Springer-Verlag, New York, pp. 340-342.
}
\keyword{utility}
