% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irregclst1.R
\name{irregclst1}
\alias{irregclst1}
\title{Convert Irregular Longitudinal Data to Regular Intervals and Perform Clustering using including Repeated Responses (IRS) method}
\usage{
irregclst1(data, subject_id_col, time_col, response_col, rel, interval_length)
}
\arguments{
\item{data}{A data frame containing the irregular longitudinal data.}

\item{subject_id_col}{A character string representing the name of the column with the subject IDs.}

\item{time_col}{A character string representing the name of the column with time values.}

\item{response_col}{A character string representing the name of the column with the response values.}

\item{rel}{Relative change method such as SRC, CARC and SWRC.}

\item{interval_length}{A numeric value indicating the length of the regular intervals to which the time values should be converted.}
}
\value{
A list containing:
\itemize{
 \item \code{regular_data}: A data frame of the regularized longitudinal data.
 \item \code{regular_data_wide}: A wide-format version of the regularized data.
 \item \code{relative_change}: A data frame containing the relative changes in response values.
 \item \code{cluster_data}: A data frame with cluster assignments for each subject at each time step.
 \item \code{cluster_data_reduced}: A reduced version of \code{cluster_data} with only subject IDs and their final cluster assignments.
 \item \code{merged_data}: The wide-format data merged with the final cluster assignments.
 \item \code{plot_irregular}: A \code{ggplot} object showing the original irregular data.
 \item \code{plot_regular}: A \code{ggplot} object showing the regularized data.
 \item \code{plot_change}: A \code{ggplot} object showing the relative changes over time.
 \item \code{histogram_irregular}: A \code{ggplot} object showing the histogram of irregular time distribution.
 \item \code{histogram_regular}: A \code{ggplot} object showing the histogram of regular time distribution.
}
}
\description{
This function takes irregular longitudinal data and converts it into regularly spaced intervals using linear interpolation. It then computes the relative change in the response variable between consecutive time points, clusters the data based on these changes, and provides various visualizations of the process.
}
\details{
The \code{irregclst1} function handles irregular longitudinal data by:
\itemize{
 \item Interpolating response values at regular time intervals without replacing the last responses.
 \item Calculating the relative change in the response values across time points.
 \item Clustering subjects based on these relative changes using alphabet labels ("a", "b", ..., "h") corresponding to different levels of deviation from the mean.
 \item Resolving cluster ties using a sum of squares criterion.
}
Visualizations of the data include plots for both the original irregular data and the regularized data, as well as histograms of time distributions and relative change trends.
}
\examples{
##
\donttest{
data(sdata)
#' #Using relative change method: Simple relative change (SRC)
fit1 <- irregclst1(sdata, "subject_id", "time", "response", rel="SRC", interval_length = 3)
fit1$regular_data #for showing the regularized data in long format
fit1$regular_data_wide #for showing the regularized data in wide format
fit1$cluster_data #dataset consisting clusters for different time points
fit1$merged_data #for showing the regularized data in wide format with final cluster
fit1$plot_regular #For plotting regularized longitudinal data
fit1$plot_irregular #For plotting irregular longitudinal data
fit1$plot_change #For plotting relative change
fit1$histogram_irregular #histogram for time of irregular data
fit1$histogram_regular #histogram for time of regular data
#Using relative change method: Cumulative average relative change (CARC)
fit2 <- irregclst1(sdata, "subject_id", "time", "response", rel="CARC", interval_length = 3)
fit2$regular_data #for showing the regularized data in long format
fit2$regular_data_wide #for showing the regularized data in wide format
fit2$cluster_data #dataset consisting clusters for different time points
fit2$merged_data #for showing the regularized data in wide format with final cluster
fit2$plot_regular #For plotting regularized longitudinal data
fit2$plot_irregular #For plotting irregular longitudinal data
fit2$plot_change #For plotting relative change
fit2$histogram_irregular #histogram for time of irregular data
fit2$histogram_regular #histogram for time of regular data
#Using relative change method: Weighted sum relative change (WSRC)
fit3 <- irregclst1(sdata, "subject_id", "time", "response", rel="WSRC", interval_length = 3)
fit3$regular_data #for showing the regularized data in long format
fit3$regular_data_wide #for showing the regularized data in wide format
fit3$cluster_data #dataset consisting clusters for different time points
fit3$merged_data #for showing the regularized data in wide format with final cluster
fit3$plot_regular #For plotting regularized longitudinal data
fit3$plot_irregular #For plotting irregular longitudinal data
fit3$plot_change #For plotting relative change
fit3$histogram_irregular #histogram for time of irregular data
fit3$histogram_regular #histogram for time of regular data
}
##
}
\references{
Reference
}
\seealso{
seealso
}
\author{
author name
}
