% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IGP_base.R
\docType{class}
\name{IGP_base}
\alias{IGP_base}
\title{UGP
Class providing object with methods for fitting a GP model}
\format{\code{\link{R6Class}} object.}
\usage{
IGP_base
}
\value{
Object of \code{\link{R6Class}} with methods for fitting GP model.
}
\description{
UGP
Class providing object with methods for fitting a GP model
}
\section{Fields}{

\describe{
\item{\code{X}}{Design matrix}

\item{\code{Z}}{Responses}

\item{\code{N}}{Number of data points}

\item{\code{D}}{Dimension of data}
}}

\section{Methods}{

\describe{
  \item{Documentation}{For full documentation of each method go to https://github.com/CollinErickson/UGP/}
  \item{\code{new(X=NULL, Z=NULL, package=NULL, corr="gauss",
  estimate.nugget=T, nugget0=F, ...)}}{This method
  is used to create object of this class with \code{X} and \code{Z} as the data.
  The package tells it which package to fit the GP model.}
  \item{\code{Xall=NULL, Zall=NULL, Xnew=NULL, Znew=NULL, ...}}{This method
  updates the model, adding new data if given, then running optimization again.}}
}

\examples{
n <- 40
d <- 2
n2 <- 20
f1 <- function(x) {sin(2*pi*x[1]) + sin(2*pi*x[2])}
X1 <- matrix(runif(n*d),n,d)
Z1 <- apply(X1,1,f1) + rnorm(n, 0, 1e-3)
X2 <- matrix(runif(n2*d),n2,d)
Z2 <- apply(X2,1,f1)
XX1 <- matrix(runif(10),5,2)
ZZ1 <- apply(XX1, 1, f1)
u <- IGP(package='laGP',X=X1,Z=Z1, corr="gauss")
cbind(u$predict(XX1), ZZ1)
u$predict.se(XX1)
u$update(Xnew=X2,Znew=Z2)
u$predict(XX1)
u$delete()
}
\keyword{Gaussian}
\keyword{data,}
\keyword{kriging,}
\keyword{process,}
\keyword{regression}
