\name{filter.wells}
\alias{filter.wells}

\title{Filter wells}
\description{Filter out wells for which the number of active electrodes is less than 4, at least 70 percent of the time}

\usage{
filter.wells(unfiltered.df, nae,min.electrodes)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{unfiltered.df}{Dataframe generated by the spike.features() function
}
  \item{nae}{A dataframe containing the number of active electrodes for the recording
}
  \item{min.electrodes}{Minimum number of active electrode to consider a well for analysis
}
}

\value{A dataframe identical in format to the input, except that wells that do not meet the filtering criteria are removed.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\examples{


	#data("S")
	#data("parameters")
	#s<-list(); s[[1]]<-S
	# spike.features<-IGM.aggregate.feature.data(s, feat.type="spike", parameters )
	# nae = spike.features$nAE
  # filtered.spike.features = lapply(spike.features, function(x) filter.wells(x, nae))
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ filter }
\keyword{ well }% __ONLY ONE__ keyword per line
