% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress_utils.R
\name{newPB}
\alias{newPB}
\title{Progress Bar Initializer}
\usage{
newPB(
  title,
  label,
  min = 0,
  max = 1,
  initial = 0,
  steps = 21,
  width,
  style,
  char = "=",
  file = "",
  ...
)
}
\arguments{
\item{title, label}{character strings, giving the 'title'(='message' for shiny progress bar) and the 'label'(='detail' for shiny progress bar).}

\item{min, max}{(finite) numeric values for the extremes of the progress bar. Must have 'min' < 'max'.}

\item{initial}{initial value for the progress bar.}

\item{steps}{(finite) numeric value for the number of individual chunk of the progress bar. Default is 21.}

\item{width}{the width of the progress bar. If missing, the default, will be NA for "txtProgressBar" and 300 for "winProgressBar".}

\item{style}{does not apply for "winProgressBar", the style of the bar. If missing, the default, will be 3 "txtProgressBar" and getShinyOption("progress.style", default = "notification") for shiny progress bar.}

\item{char}{only apply for "txtProgressBar", the character (or character string) to form the progress bar.}

\item{file}{only apply for "txtProgressBar", an open connection object or "" which indicates the console: stderr() might be useful here. Default is "".}

\item{...}{Other arguments to be passed.}
}
\value{
pb an object of class `IFC_progress` containing a progress bar of class `txtProgressBar`, `winProgressBar` or `Progress`.
}
\description{
Initializes a progress bar.
}
\details{
shiny progress bar will be available only if shiny package is found and within a shiny app.
}
\keyword{internal}
