% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExportToReport.R
\name{relayout}
\alias{relayout}
\title{Change Graphs Layout}
\usage{
relayout(
  graphs,
  size = 320,
  splitterdistance = 120,
  stats = TRUE,
  byrow = FALSE,
  times = 4,
  layout = NULL
)
}
\arguments{
\item{graphs}{an `IFC_graphs` object extracted with features extracted.}

\item{size}{Integer, graphs' sizes. Default is 320.}

\item{splitterdistance}{Integer. Default is 120.}

\item{stats}{Logical. Whether to show stats or not. Default is TRUE.}

\item{byrow}{Logical. Whether to layout graphs by row or not. Default is FALSE.}

\item{times}{Integer. Max number of graphs by row/column (depending on `byrow`). Default is 4.}

\item{layout}{Integer matrix. Desired layout. Default is NULL.
When NULL, the default, graphs will be relayout using `times` and `byrow` parameters.
Otherwise, layout will be used to determine the position of the graphs (NA value can be used for empty place).
Note that when not NULL layout should contain all indices of graphs only once.}
}
\value{
an  `IFC_graphs` object
}
\description{
Reconstructs `IFC_graphs` object layout.
}
\keyword{internal}
