% Generated by roxygen2 (4.0.2): do not edit by hand
\name{get.theta.typed}
\alias{get.theta.typed}
\title{Optimized version of \code{get.theta} for typed data.}
\usage{
get.theta.typed(posmat, typeA = -1, typeB = -1, r = 1, r.low = rep(0,
  length(r)))
}
\arguments{
\item{posmat}{a matrix with columns type, x and y}

\item{typeA}{the "from" type that we are interested in, -1 is wildcard}

\item{typeB}{the "to" type that we are interested i, -1 is wildcard}

\item{r}{the series of spatial distances wer are interested in}

\item{r.low}{the low end of each range....0  by default}
}
\value{
theta values for all the distances we looked at
}
\description{
Version of the \code{get.theta} function that is optimized for statically typed data. That is
data where we are interested in the odds that points within some distance of points of
typeA are of typeB.
}
\examples{
data(DengueSimulationR02)

r.max<-seq(20,1000,20)
r.min<-seq(0,980,20)

#Lets see if there's a difference in spatial dependence by time case occurs
type<-2-(DengueSimR02[,"time"]<120)
tmp<-cbind(DengueSimR02,type=type)

typed.theta.R01<-get.theta.typed(tmp,typeA=2,typeB=2,r=r.max,r.low=r.min)
}
\author{
Justin Lessler and Henrik Salje
}
\seealso{
Other get.theta: \code{\link{get.theta.bootstrap}};
  \code{\link{get.theta.ci}};
  \code{\link{get.theta.permute}};
  \code{\link{get.theta.typed.bootstrap}};
  \code{\link{get.theta.typed.permute}};
  \code{\link{get.theta}}
}

