% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialfuncs.r
\name{get.tau.ci}
\alias{get.tau.ci}
\title{Bootstrap confidence interval for the \code{get.tau} values}
\usage{
get.tau.ci(posmat, fun, r = 1, r.low = rep(0, length(r)),
  boot.iter = 1000, comparison.type = "representative", ci.low = 0.025,
  ci.high = 0.975)
}
\arguments{
\item{posmat}{a matrix appropriate for input to \code{get.tau}}

\item{fun}{a function appropriate as input to \code{get.pi}}

\item{r}{the series of spatial distances we are interested in}

\item{r.low}{the low end of each range....0  by default}

\item{boot.iter}{the number of bootstrap iterations}

\item{comparison.type}{the comparison type to pass to get.tau}

\item{ci.low}{the low end of the ci...0.025 by default}

\item{ci.high}{the high end of the ci...0.975 by default}
}
\value{
tau values for all the distances examined
}
\description{
Wrapper to \code{get.tau.bootstrap} that takes care of calulating
the confidence intervals based on the bootstrapped values
}
\examples{
\dontrun{
 R/examples/get_tau_ci.R
 }

}
\author{
Justin Lessler and Henrik Salje
}
\seealso{
Other get.tau: \code{\link{get.tau.bootstrap}},
  \code{\link{get.tau.permute}},
  \code{\link{get.tau.typed.bootstrap}},
  \code{\link{get.tau.typed.permute}},
  \code{\link{get.tau.typed}}, \code{\link{get.tau}}
}

