% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CaseCohortIC.R
\name{CaseCohortIC}
\alias{CaseCohortIC}
\title{Case-Cohort Studies with Interval-Censored Failure Time Data}
\usage{
CaseCohortIC(U, V, del1, del2, xi, z, sp, mVal, B, beta = NULL,
  maxit = 10L, verbose = TRUE, ...)
}
\arguments{
\item{U}{numeric vector (n); examination time. 
See Details for further information.}

\item{V}{numeric vector (n); examination time.
See Details for further information.}

\item{del1}{integer vector (n); indicator of a left-censored observation I(T<=U).
See Details for further information.}

\item{del2}{integer vector (n); indicator of an interval-censored observation I(U<T<=V).
See Details for further information.}

\item{xi}{integer vector (n); indicating membership of the case-cohort sample.}

\item{z}{matrix (nxp); covariates.}

\item{sp}{numeric (1); sampling probability 0 < sp < 1.}

\item{mVal}{integer vector (m); one or more options for the degree of 
the Bernstein polynomials. If more than one option provided, the value 
resulting in the lowest
AIC is selected. The results returned are for only that m-value.}

\item{B}{integer (1); number of bootstrap samples used to calculate the variance
estimate.}

\item{beta}{numeric vector (p); initial values for beta. If NULL, initial
guess set to 0.5 for each of the p parameters.}

\item{maxit}{integer(1); maximum number of calls to optimization method.}

\item{verbose}{logical; TRUE generates progress screen prints.}

\item{...}{optional inputs to "control" of function optim().}
}
\value{
an object of class CaseCohort (inheriting from ICODS) containing
\item{optim}{a list of the results returned by optim().}
\item{beta}{the estimated beta parameters.}
\item{se}{the standard error of the estimated beta parameters.}
\item{pValue}{the p-value of the estimated beta parameters.}
\item{m}{the selected degree of the Bernstein polynomials.}
\item{AIC}{the AIC value for the selected degree of the Bernstein polynomials.}
}
\description{
Provides a sieve semiparametric likelihood approach under the proportional 
  hazards model for analyzing data from a case-cohort design with failure 
  times subject to interval-censoring. The likelihood function is constructed
  using inverse probability weighting, and the sieves are built with 
  Bernstein polynomials. A weighted bootstrap procedure is implemented for 
  variance estimation.
}
\details{
The implementation uses stats::optim() to minimize the likelihood. The
  hard-coded method is "BFGS". Users are able to make changes to the
  'control' input of optim() by passing named inputs through the ellipses.
  If a call to optim() returns convergence = 1, i.e., optim() reached its
  internal maximum number of iterations before convergence was attained,
  the software automatically repeats the call to optim() with input 
  variable par set to the last parameter values. This procedure is 
  repeated at most maxit times.

Input parameters U, V, del1, and del2 are defined as follows. 
  Suppose there are 
  K follow-up examinations at times TE = (T1, T2, ..., TK), and the failure
  time is denoted as TF. 
  For left-censored data, the failure occurs prior to the first 
  follow-up examination (TF < T1); therefore, define U = T1, V = tau, and 
  (del1,del2)=(1,0). For right-censored data, the
  failure has not yet occurred at the last follow-up examination 
  (TF > TK); therefore, define U = 0, V = TK, 
  and (del1,del2)=(0,0). For interval-censored data, the failure occurs
  between two follow-up examinations, e.g. T2 < TF < T3; therefore, 
  define U and V to be the two consecutive follow-up examination times 
  bracketing the failure time TF and (del1,del2)=(0,1).
}
\examples{

data(ccData)

result <- CaseCohortIC(U = ccData$U, 
                       V = ccData$V,  
                       del1 = ccData$del1,  
                       del2 = ccData$del2, 
                       xi = ccData$xi,
                       z = ccData$z, 
                       sp = 0.2, 
                       mVal = 1L,
                       B = 10L, 
                       beta = NULL, 
                       maxit = 10L,
                       verbose = TRUE)

print(result)
mVal(result)
estimate(result)
optimObj(result)
minAIC(result)
summary(result)

}
\references{
Zhou, Q., Zhou, H., and Cai, J. (2017). Case-cohort studies 
  with interval-censored failure time data. Biometrika, 104(1): 17--29. 
  <doi:10.1093/biomet/asw067>
}
