% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICDS.r
\name{FindSubPath}
\alias{FindSubPath}
\title{FindSubPath}
\usage{
FindSubPath(
  zz,
  Pathway = "kegg",
  delta = 0.05,
  seed_p = 0.05,
  min.size = 5,
  out.F = FALSE,
  out.file = "Subpath.txt"
)
}
\arguments{
\item{zz}{A numeric vector of z_scores.}

\item{Pathway}{The name of the pathway database.}

\item{delta}{Diffusion coefficient in each step of searching subpath.}

\item{seed_p}{Define gene whose p-value smaller than seed_p as seed gene.}

\item{min.size}{The smallest size of subpathways.}

\item{out.F}{Logical,tell if output subpathways.}

\item{out.file}{file name of subpathways.}
}
\value{
Key dysfunctional subpathways in each pathway, in which the risk score of the genes were significantly higher.
}
\description{
`FindSubPath` uses a greedy search algorithm to search for key subpathways in each entire pathway.
}
\examples{
require(graphite)
zz<-GetExampleData("zzz")
\donttest{k<-FindSubPath(zz)}
}
