% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_related_functions.R
\name{StrelkaSBSVCFFilesToZipFile}
\alias{StrelkaSBSVCFFilesToZipFile}
\title{Create a zip file which contains catalogs and plot PDFs from Strelka SBS VCF files}
\usage{
StrelkaSBSVCFFilesToZipFile(
  dir,
  zipfile,
  ref.genome,
  trans.ranges = NULL,
  region = "unknown",
  names.of.VCFs = NULL,
  base.filename = "",
  return.annotated.vcfs = FALSE,
  suppress.discarded.variants.warnings = TRUE
)
}
\arguments{
\item{dir}{Pathname of the directory which contains \strong{only} the Strelka
SBS VCF files. Each Strelka SBS VCF \strong{must} have a file extension
".vcf" (case insensitive) and share the \strong{same} \code{ref.genome} and
\code{region}.}

\item{zipfile}{Pathname of the zip file to be created.}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{trans.ranges}{Optional. If \code{ref.genome} specifies one of the
\code{\link{BSgenome}} object 
\enumerate{
  \item \code{\link[BSgenome.Hsapiens.1000genomes.hs37d5]{BSgenome.Hsapiens.1000genomes.hs37d5}}
  \item \code{\link[BSgenome.Hsapiens.UCSC.hg38]{BSgenome.Hsapiens.UCSC.hg38}}
  \item \code{\link[BSgenome.Mmusculus.UCSC.mm10]{BSgenome.Mmusculus.UCSC.mm10}}
}
then the function will infer \code{trans.ranges} automatically. Otherwise,
user will need to provide the necessary \code{trans.ranges}. Please refer to
\code{\link{TranscriptRanges}} for more details.
If \code{is.null(trans.ranges)} do not add transcript range
information.}

\item{region}{A character string designating a genomic region;
see \code{\link{as.catalog}} and \code{\link{ICAMS}}.}

\item{names.of.VCFs}{Optional. Character vector of names of the VCF files.
The order of names in \code{names.of.VCFs} should match the order of VCFs
listed in \code{dir}. If \code{NULL}(default), this function will remove
all of the path up to and including the last path separator (if any) in
\code{dir} and file paths without extensions (and the leading dot) will be
used as the names of the VCF files.}

\item{base.filename}{Optional. The base name of the CSV and PDF files to be
produced; multiple files will be generated, each ending in
\eqn{x}\code{.csv} or \eqn{x}\code{.pdf}, where \eqn{x} indicates the type
of catalog.}

\item{return.annotated.vcfs}{Logical. Whether to return the annotated VCFs
with additional columns showing mutation class for each variant. Default is
FALSE.}

\item{suppress.discarded.variants.warnings}{Logical. Whether to suppress
warning messages showing information about the discarded variants. Default
is TRUE.}
}
\description{
Create 3 SBS catalogs (96, 192, 1536), 3 DBS catalogs (78, 136, 144) from the
Strelka SBS VCFs specified by \code{dir}, save the catalogs as CSV files,
plot them to PDF and generate a zip archive of all the output files. The
function will find and merge adjacent SBS pairs into DBS if their VAFs are
very similar. The default threshold value for VAF is 0.02.
}
\details{
This function calls \code{\link{StrelkaSBSVCFFilesToCatalog}},
\code{\link{PlotCatalogToPdf}}, \code{\link{WriteCatalog}} and
\code{\link[zip]{zipr}}.
}
\section{Value}{

A list containing the following objects:
\itemize{
\item \code{catSBS96}, \code{catSBS192}, \code{catSBS1536}: Matrix of
3 SBS catalogs (one each for 96, 192, and 1536).
\item \code{catDBS78}, \code{catDBS136}, \code{catDBS144}: Matrix of
3 DBS catalogs (one each for 78, 136, and 144).
\item \code{discarded.variants}: \strong{Non-NULL only if} there are variants
that were excluded from the analysis. See the added extra column
\code{discarded.reason} for more details.
\item \code{annotated.vcfs}:
\strong{Non-NULL only if} \code{return.annotated.vcfs} = TRUE.
A list of elements:
\itemize{
\item \code{SBS}: SBS VCF annotated by \code{\link{AnnotateSBSVCF}} with
three new columns \code{SBS96.class}, \code{SBS192.class} and
\code{SBS1536.class} showing the mutation class for each SBS variant.
\item \code{DBS}: DBS VCF annotated by \code{\link{AnnotateDBSVCF}} with
three new columns \code{DBS78.class}, \code{DBS136.class} and
\code{DBS144.class} showing the mutation class for each DBS variant.
}
}

If \code{trans.ranges} is not provided by user and cannot be inferred by
ICAMS, SBS 192 and DBS 144 catalog will not be generated. Each catalog has
attributes added. See \code{\link{as.catalog}} for more details.
}

\section{Note}{
 SBS 192 and DBS 144 catalogs include only mutations in
transcribed regions.
}

\section{Comments}{

To add or change attributes of the catalog, you can use function
\code{\link[base]{attr}}. \cr For example, \code{attr(catalog, "abundance")
<- custom.abundance}.
}

\examples{
dir <- c(system.file("extdata/Strelka-SBS-vcf",
                     package = "ICAMS"))
if (requireNamespace("BSgenome.Hsapiens.1000genomes.hs37d5", quietly = TRUE)) {
  catalogs <- 
    StrelkaSBSVCFFilesToZipFile(dir, 
                                zipfile = file.path(tempdir(), "test.zip"),
                                ref.genome = "hg19", 
                                trans.ranges = trans.ranges.GRCh37,
                                region = "genome",
                                base.filename = "Strelka-SBS")
  unlink(file.path(tempdir(), "test.zip"))}
}
