% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{StrelkaSBSVCFFilesToCatalogAndPlotToPdf}
\alias{StrelkaSBSVCFFilesToCatalogAndPlotToPdf}
\title{Create SBS and DBS catalogs from Strelka SBS VCF files and plot them to PDF}
\usage{
StrelkaSBSVCFFilesToCatalogAndPlotToPdf(
  files,
  ref.genome,
  trans.ranges = NULL,
  region = "unknown",
  names.of.VCFs = NULL,
  output.file = ""
)
}
\arguments{
\item{files}{Character vector of file paths to the Strelka SBS VCF files.}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{trans.ranges}{Optional. If \code{ref.genome} specifies one of the
\code{\link{BSgenome}} object 
\enumerate{
  \item \code{\link[BSgenome.Hsapiens.1000genomes.hs37d5]{BSgenome.Hsapiens.1000genomes.hs37d5}}
  \item \code{\link[BSgenome.Hsapiens.UCSC.hg38]{BSgenome.Hsapiens.UCSC.hg38}}
  \item \code{\link[BSgenome.Mmusculus.UCSC.mm10]{BSgenome.Mmusculus.UCSC.mm10}}
}
then the function will infer \code{trans.ranges} automatically. Otherwise,
user will need to provide the necessary \code{trans.ranges}. Please refer to
\code{\link{TranscriptRanges}} for more details.
If \code{is.null(trans.ranges)} do not add transcript range
information.}

\item{region}{A character string designating a genomic region;
see \code{\link{as.catalog}} and \code{\link{ICAMS}}.}

\item{names.of.VCFs}{Optional. Character vector of names of the VCF files.
The order of names in \code{names.of.VCFs} should match the order of VCF
file paths in \code{files}. If \code{NULL}(default), this function will
remove all of the path up to and including the last path separator (if any)
in \code{files} and file paths without extensions (and the leading dot)
will be used as the names of the VCF files.}

\item{output.file}{Optional. The base name of the PDF files to be produced;
multiple files will be generated, each ending in \eqn{x}\code{.pdf}, where
\eqn{x} indicates the type of catalog plotted in the file.}
}
\value{
A list of 3 SBS catalogs (one each for 96, 192, and 1536), 3 DBS
  catalogs (one each for 78, 136, and 144) and their graphs plotted to PDF
  with specified file name. If trans.ranges = NULL, SBS 192 and DBS 144
  catalog will not be generated and plotted. Each catalog has attributes
  added. See \code{\link{as.catalog}} for more details.
}
\description{
Create 3 SBS catalogs (96, 192, 1536) and 3 DBS catalogs (78, 136, 144) from the
Strelka SBS VCFs specified by \code{files} and plot them to PDF
}
\details{
This function calls \code{\link{StrelkaSBSVCFFilesToCatalog}} and
\code{\link{PlotCatalogToPdf}}
}
\note{
SBS 192 and DBS 144 catalogs include only mutations in transcribed regions.
}
\section{Comments}{

To add or change attributes of the catalog, you can use function
\code{\link[base]{attr}}. \cr For example, \code{attr(catalog, "abundance")
<- custom.abundance}.
}

\examples{
file <- c(system.file("extdata/Strelka-SBS-vcf",
                      "Strelka.SBS.GRCh37.s1.vcf",
                      package = "ICAMS"))
if (requireNamespace("BSgenome.Hsapiens.1000genomes.hs37d5", quietly = TRUE)) {
  catalogs <- 
    StrelkaSBSVCFFilesToCatalogAndPlotToPdf(file, ref.genome = "hg19",
                                            trans.ranges = trans.ranges.GRCh37,
                                            region = "genome",
                                            output.file = 
                                            file.path(tempdir(), "StrelkaSBS"))}
}
