% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{CreateOneColDBSMatrix}
\alias{CreateOneColDBSMatrix}
\title{Create the matrix a DBS catalog for *one* sample from an in-memory VCF.}
\usage{
CreateOneColDBSMatrix(vcf, sample.id = "count")
}
\arguments{
\item{vcf}{An in-memory VCF file annotated with sequence context and
transcript information by function \code{\link{AnnotateDBSVCF}}. It must
*not* contain indels and must *not* contain SBS (single base
substitutions), or triplet base substitutions etc.}

\item{sample.id}{Usually the sample id, but defaults to "count".}
}
\value{
A list of three 1-column matrices with the names \code{catDBS78},
  \code{catDBS144}, and \code{catDBS136}. If trans.ranges is NULL,
  \code{catDBS144} is not generated. Do not rely on the order of elements in
  the list.
}
\description{
Create the matrix a DBS catalog for *one* sample from an in-memory VCF.
}
\note{
DBS 144 catalog only contains mutations in transcribed regions.
}
\keyword{internal}
