% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{AddSeqContext}
\alias{AddSeqContext}
\title{Add sequence context to a data frame with mutation records}
\usage{
AddSeqContext(df, ref.genome, seq.context.width = 10)
}
\arguments{
\item{df}{An input data frame storing mutation records of a VCF file.}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{seq.context.width}{The number of preceding and following bases to be
extracted around the mutated position from \code{ref.genome}. The default value is 10.}
}
\value{
A copy of the input data.frame with a new column added
    that contains sequence context information.
}
\description{
Add sequence context to a data frame with mutation records
}
\keyword{internal}
