% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{VCFsToSBSCatalogs}
\alias{VCFsToSBSCatalogs}
\title{Create SBS catalogs from SBS VCFs}
\usage{
VCFsToSBSCatalogs(list.of.SBS.vcfs, ref.genome, trans.ranges = NULL,
  region = "unknown")
}
\arguments{
\item{list.of.SBS.vcfs}{List of in-memory data frames of pure SBS mutations
-- no DBS or 3+BS mutations. The list names will be the sample ids in the
output catalog.}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{trans.ranges}{a \code{\link[data.table]{data.table}} which contains
transcript range and strand information. Please refer to
\code{\link{TranscriptRanges}} for more details.}

\item{region}{A character string designating a genomic region;
see \code{\link{as.catalog}} and \code{\link{ICAMS}}.}
}
\value{
A list of 3 SBS catalogs, one each for 96, 192, 1536: catSBS96
  catSBS192 catSBS1536. If trans.ranges = NULL, SBS 192 catalog will not be
  generated. Each catalog has attributes added. See \code{\link{as.catalog}}
  for more details.
}
\description{
Create a list of 3 catalogs (one each for 96, 192, 1536)
out of the contents in list.of.SBS.vcfs. The SBS VCFs must not contain
DBSs, indels, or other types of mutations.
}
\note{
SBS 192 catalogs only contain mutations in transcribed regions.
}
\examples{
file <- c(system.file("extdata",
                      "Mutect.GRCh37.vcf",
                      package = "ICAMS"))
list.of.SBS.vcfs <- ReadAndSplitMutectVCFs(file)$SBS
catalogs.SBS <- VCFsToSBSCatalogs(list.of.SBS.vcfs, ref.genome = "hg19",
                                  trans.ranges = trans.ranges.GRCh37,
                                  region = "genome")
}
