% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{as.catalog}
\alias{as.catalog}
\title{Create a catalog from a numeric \code{matrix} or numeric \code{data.frame}.}
\usage{
as.catalog(object, ref.genome = NULL, region = "unknown",
  catalog.type = "counts", abundance = NULL)
}
\arguments{
\item{object}{A numeric \code{matrix} or numeric \code{data.frame}. 
This object must have
 rownames to denote the mutation types. See \code{\link{CatalogRowOrder}}
 for more details.}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{region}{A character string designating a region, one of
\code{genome}, \code{transcript}, \code{exome}, \code{unknown};
see \code{\link{ICAMS}}.}

\item{catalog.type}{One of "counts", "density", "counts.signature",
"density.signature".}

\item{abundance}{If \code{NULL}, then
inferred if \code{ref.genome}
is one of
the reference genomes known to ICAMS and \code{region}
is not \code{unknown}. See \code{\link{ICAMS}}.
The argument \code{abundance} should
contain the counts of different source sequences for mutations
in the same format as the numeric vectors in \code{\link{all.abundance}}.}
}
\value{
A catalog as described in \code{\link{ICAMS}}.
}
\description{
Create a catalog from a numeric \code{matrix} or numeric \code{data.frame}.
}
\examples{
# Create an SBS96 catalog of human GRCh37 from genome region with all 
# mutation counts equal to 1.  
object <- matrix(1, nrow = 96, ncol = 1, 
                 dimnames = list(catalog.row.order$SBS96))
catSBS96 <- as.catalog(object, ref.genome = "hg19", region = "genome")
}
