% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{ReadStrelkaIDVCFs}
\alias{ReadStrelkaIDVCFs}
\title{Read Strelka ID (insertion and deletion) VCF files.}
\usage{
ReadStrelkaIDVCFs(files)
}
\arguments{
\item{files}{Character vector of file paths to the VCF files.}
}
\value{
A list of vcfs from \code{files}.
}
\description{
Read Strelka ID (insertion and deletion) VCF files.
}
\note{
In ID (insertion and deletion) catalogs, deletion repeat sizes
  range from 0 to 5+, but for plotting and end-user documentation
  deletion repeat sizes range from 1 to 6+.
}
\examples{
file <- c(system.file("extdata",
                      "Strelka.ID.GRCh37.vcf",
                      package = "ICAMS"))
list.of.vcfs <- ReadStrelkaIDVCFs(file)
}
\seealso{
\code{\link{StrelkaIDVCFFilesToCatalog}}
}
