% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{SplitListOfMutectVCFs}
\alias{SplitListOfMutectVCFs}
\title{Split each Mutect VCF into SBS, DBS, and ID VCFs (plus two
VCF-like data frame with left-over rows).}
\usage{
SplitListOfMutectVCFs(list.of.vcfs)
}
\arguments{
\item{list.of.vcfs}{List of VCFs as in-memory data.frames.}
}
\value{
A list with 3 in-memory VCFs and two left-over
VCF-like data frames with rows that were not incorporated
into the first 3 VCFs, as follows:

\enumerate{

 \item \code{SBS} VCF with only single base substitutions.

 \item \code{DBS} VCF with only doublet base substitutions
  as called by Mutect.

 \item \code{ID} VCF with only small insertions and deletions.

 \item \code{other.subs} VCF like data.frame with
 rows for coordinate substitutions involving
 3 or more nucleotides, e.g. ACT > TGA or AACT > GGTA.

 \item \code{multiple.alternative.alleles} VCF like data.frame with
 rows for variants with multiple alternative alleles, for example
 ACT mutated to both AGT and ACT at the same position.

}
}
\description{
Split each Mutect VCF into SBS, DBS, and ID VCFs (plus two
VCF-like data frame with left-over rows).
}
\keyword{internal}
