% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Td2M.R
\name{getMatrixForm}
\alias{getMatrixForm}
\title{Tidy data format to Matrix format}
\usage{
getMatrixForm(Tidy_DataSet, onlyTrait = FALSE)
}
\arguments{
\item{Tidy_DataSet}{\code{data.frame} object that contains 4 columns:
\code{$Line}: Line or genotype identifier, and the name of this column could change.
\code{$Env}: Name of the evaluated environment (s).
\code{$Trait}: Name of the evaluated trait (s).
\code{$Response}: Variable response obtained for the row corresponding to line and environment.}

\item{onlyTrait}{\code{logical} by default is \code{FALSE}, if is \code{TRUE} only the column \code{$Trait} is transformed.}
}
\value{
A \code{data.frame} object with the \code{$Response} divided by \code{$Traits} columns.
}
\description{
Tidy data format to Matrix format
}
\examples{
\dontrun{
  data('Wheat_IBCF')
  M <- getMatrixForm(Wheat_IBCF)
}

\dontrun{
  data('Year_IBCF')
  M.Y <- getMatrixForm(Year_IBCF, onlyTrait = T)
}
}
