% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foopTTable.R
\name{hTpcteTab}
\alias{hTpcteTab}
\title{Table of Enthalpies, Function of Temperature and Fixed Pressure}
\usage{
hTpcteTab(T1, T2, dT, p)
}
\arguments{
\item{T1}{first Temperature value [ K ]}

\item{T2}{final Temperature [ K ]}

\item{dT}{Temperature increment [ K ]}

\item{p}{Pressure [ MPa ]}
}
\value{
A table of Enthalpies for fixed p and a T Interval: T1:T2.
}
\description{
The function \code{hTpcteTab(T1, T2, dT, p)} returns a table of 
    enthalpies [kJ kg-1] for a fixed p [MPa] within a range of Temp [K]: T1:T2 [K]
}
\details{
This function calls a Fortran DLL that solves the Helmholtz Energy Equation. 
    in accordance with the Revised Release on the IAPWS Formulation 1995 for the 
    Thermodynamic Properties of Ordinary Water Substance for General and Scientific
    Use (June 2014) developed by the International Association for the Properties of
    Water and Steam,  \url{http://www.iapws.org/relguide/IAPWS-95.html}. It is valid  
    from the triple point to the pressure of 1000 MPa and temperature of 1273.
}
\examples{
T1 <- 275.
T2 <- 450.
dT <- 5.
p <- 5.
Tabh <-  hTpcteTab(T1, T2, dT, p)
Tabh

T1 <- 300.
T2 <- 500.
dT <- 10.
p <- 10.
Tabh <- hTpcteTab(T1, T2, dT, p)
Tabh

}
