% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution.R
\name{extract_distribution}
\alias{extract_distribution}
\title{Extract a distribution represented by samples}
\usage{
extract_distribution(
  object,
  parName = "",
  type = c("continuous", "discrete", "eti", "hdi"),
  transform = identity,
  ...
)
}
\arguments{
\item{object}{Object specifying the distribution as samples: can be a Stanfit object,
a matrix (columns represents parameters, rows samples) or a vector.}

\item{parName}{Name of the parameter to extract.}

\item{type}{Indicates how the distribution is summarised.}

\item{transform}{Function to apply to the samples.}

\item{...}{Arguments to pass to \code{\link[=extract_pmf]{extract_pmf()}}, \code{\link[=extract_pdf]{extract_pdf()}} or \code{\link[=extract_ci]{extract_ci()}} depending on \code{type}.}
}
\value{
Dataframe
}
\description{
The distribution can be extracted as:
\itemize{
\item a probability density function ("continuous").
\item a probability mass function ("discrete").
\item a series of equal-tailed confidence/credible intervals ("eti").
\item a series of highest density confidence/credible intervals ("hdi").
}
}
\section{Alternative}{

This function can notably be used to prepare the data for plotting fan charts when type = "eti" or "hdi".
In that case, the \href{https://mjskay.github.io/ggdist/}{\code{ggdist}} package offers an alternative with \code{ggdist::stat_lineribbon()}.
}

\examples{
extract_distribution(runif(1e2), type = "continuous", support = c(0, 1))
}
\seealso{
\code{\link[=extract_draws]{extract_draws()}} for extracting draws of an object.
}
