% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clr.R
\name{clr}
\alias{clr}
\title{Centered log ratio transformation}
\usage{
clr(data, group = NULL)
}
\arguments{
\item{data}{a data frame in which the data is stored}

\item{group}{if not NULL then a character string specifying the name of the
grouping variable}
}
\value{
a data frame with the CLR transformation applied to data. Each row
in the data frame is standardized by dividing by the geometric mean of that
row. The logarithms of the resulting ratios are returned. If a grouping
variable is specified, then this is preserved.
}
\description{
Aitchison's centered log ratio tranformation for compositional data
}
\details{
This function will give a warning if zeros are present because the
transformed data will have -Infs.
}
\examples{

data(bottle.df)

## transform preserving grouping
clr(bottle.df, "Number")

## transform the data but remove the
## grouping in column 1
clr(bottle.df[,-1])

}
\references{
Aitchison, J. (1986). ``The Statistical Analysis of
Compositional Data'', Chapman and Hall, reprinted in 2003 with additional
material by The Blackburn Press
}
\seealso{
alr
}
\author{
James M. Curran
}
\keyword{transformation}
