% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setPriors.Hmsc.R
\name{setPriors.Hmsc}
\alias{setPriors.Hmsc}
\title{setPriors.Hmsc}
\usage{
\method{setPriors}{Hmsc}(
  hM,
  V0 = NULL,
  f0 = NULL,
  mGamma = NULL,
  UGamma = NULL,
  aSigma = NULL,
  bSigma = NULL,
  nuRRR = NULL,
  a1RRR = NULL,
  b1RRR = NULL,
  a2RRR = NULL,
  b2RRR = NULL,
  rhopw = NULL,
  setDefault = FALSE,
  ...
)
}
\arguments{
\item{hM}{a fitted \code{Hmsc} model object}

\item{V0}{scale matrix in the Wishart prior distribution for the V matrix}

\item{f0}{number of degrees of freedom in the Wishart prior distribution for the V matrix}

\item{mGamma}{mean for the prior multivariate Gaussian distribution for Gamma parameters}

\item{UGamma}{covariance matrix for the prior multivariate Gaussian distribution for Gamma parameters}

\item{aSigma}{shape parameter for the prior gamma distribution for the variance parameter, only for normal & lognormal Poisson models}

\item{bSigma}{rate parameter for the prior gamma distribution for the variance parameter, only for normal & lognormal Poisson models}

\item{nuRRR, a1RRR, b1RRR, a2RRR, b2RRR}{parameters of the multiplicative gamma process shrinking prior for reduced rank regression}

\item{rhopw}{discrete grid prior for phylogenetic signal, should be a matrix of 2 columns}

\item{setDefault}{logical indicating whether default priors should be used}

\item{\dots}{other parameters passed to the function.}
}
\value{
Modified \code{Hmsc} object
}
\description{
Sets or resets priors to the \code{Hmsc} object
}
