% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcMID.R
\name{CalcMID}
\alias{CalcMID}
\title{CalcMID.}
\usage{
CalcMID(int = NULL, fml = "", ratio = NULL, nmz = NULL, nbio = NULL)
}
\arguments{
\item{int}{Vector of measured ion intensities of a fragment.}

\item{fml}{Chemical formula of fragment.}

\item{ratio}{If NULL M+H/M+ ratio will be determined from the data if necessary. Can be specified explicitly here.}

\item{nmz}{Attached as attr to fml for \link{CalcTheoreticalMDV}.}

\item{nbio}{Attached as attr to fml for \link{CalcTheoreticalMDV}.}
}
\value{
Percent representation of each isotopologue measured (=MIDs).
}
\description{
\code{CalcMID} will compute a MID (Mass Isotopomer Distribution) based on measured ion intensities in GC-APCI-MS.
}
\details{
Let's assume we measured the ion intensities of all 3 isotopes of an individual compound containing 2 carbons and observe a vector of {978,22,0}.
We may calculate the enrichment (E) out of this data, i.e. the relative proportion of 13C vs total carbon which will amount to about 1.1% (the natural 13C abundance) under standard conditions.
The equvivalent MID vector would be {1,0,0}, indicating that the non-labeled isotopologue (where non-labeled means non-labled above the natural 1.1%) is the only component observed.
During a labelling experiment we may change the measurement values in different ways (either labelling only one carbon or both), which potentially can translate into similar values for E being larger 1.1%.
The MIDs will provide additional information about the isotopolouge fraction which gave rise to the observed E's (cf. examples).
}
\examples{
#tbd
}
