% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_BIC.R
\name{compare_BIC}
\alias{compare_BIC}
\title{Compares the BIC of several outputs}
\usage{
compare_BIC(..., factor.value = -1, silent = FALSE)
}
\arguments{
\item{...}{Successive results to be compared as lists.}

\item{factor.value}{The $value of the list object is multiplied by factor.value to calculate BIC.}

\item{silent}{If TRUE, nothing is displayed.}
}
\value{
A list with DeltaBIC and Akaike weight for the models.
}
\description{
This function is used to compare the BIC of several outputs obtained with the same data but with different set of parameters.\cr
Each object must have associated \code{logLik()} method with df and nobs attributes.\cr
BIC for object x will be calculated as \code{2*factor.value*sum(logLik(x))+sum(attributes(logLik(x))$df)*log(attributes(logLik(x))$nobs))}.\cr
When several data (i..n) are included, the global BIC is calculated as:\cr
\code{2*factor.value*sum(logLik(x)) for i..n+sum(attributes(logLik(x))$df) for i..n*log(attributes(logLik(x))$nobs for i..n))}
}
\details{
compare_BIC compares the BIC of several outputs obtained with the same data.
}
\examples{
\dontrun{
library("HelpersMG")
# Here two different models are fitted
x <- 1:30
y <- rnorm(30, 10, 2)+log(x)
plot(x, y)
d <- data.frame(x=x, y=y)
m1 <- lm(y ~ x, data=d)
m2 <- lm(y ~ log(x), data=d)
compare_BIC(linear=m1, log=m2, factor.value=-1)
# Here test if two datasets can be modeled with a single model
x2 <- 1:30
y2 <- rnorm(30, 15, 2)+log(x2)
plot(x, y, ylim=c(5, 25))
plot_add(x2, y2, col="red")
d2 <- data.frame(x=x2, y=y2)
m1_2 <- lm(y ~ x, data=d2)
x_grouped <- c(x, x2)
y_grouped <- c(y, y2)
d_grouped <- data.frame(x=x_grouped, y=y_grouped)
m1_grouped <- lm(y ~ x, data=d_grouped)
compare_BIC(separate=list(m1, m1_2), grouped=m1_grouped, factor.value=-1)
}
}
\seealso{
Other AIC: \code{\link{ExtractAIC.glm}},
  \code{\link{compare_AICc}}, \code{\link{compare_AIC}}
}
\author{
Marc Girondot
}
\concept{AIC}
