% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dSnbinom.R
\name{dSnbinom}
\alias{dSnbinom}
\title{Density for the sum of random variable with negative binomial distributions.}
\usage{
dSnbinom(x = stop("You must provide a x value"), size = NULL, prob = NULL,
  mu = NULL, log = FALSE, infinite = 100)
}
\arguments{
\item{x}{vector of (non-negative integer) quantiles.}

\item{size}{target for number of successful trials, or dispersion parameter (the shape parameter of the gamma mixing distribution). Must be strictly positive, need not be integer.}

\item{prob}{probability of success in each trial. 0 < prob <= 1.}

\item{mu}{alternative parametrization via mean.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{infinite}{Number of maximal iterations; check different values to determine the error in estimation.}
}
\value{
dSnbinom gives the density
}
\description{
Density for the sum of random variable with negative binomial distributions.\cr
If all prob values are the same, infinite is automatically set to 0.
}
\details{
dSnbinom returns the density for the sum of random variable with negative binomial distributions
}
\author{
Marc Girondot
}
\references{
Furman, E., 2007. On the convolution of the negative binomial random variables. Statistics & Probability Letters 77, 169-172.
}
\seealso{
Other Distribution of sum of random variable with negative binomial distributions: \code{\link{pSnbinom}},
  \code{\link{qSnbinom}}, \code{\link{rSnbinom}}
}

