% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HeckmanEM.R
\name{HeckmanEM}
\alias{HeckmanEM}
\title{Fit the Normal or Student-t Heckman Selectio model.}
\usage{
HeckmanEM(
  y,
  x,
  w,
  cc,
  nu = 4,
  family = "T",
  error = 1e-05,
  iter.max = 500,
  im = TRUE,
  criteria = TRUE
)
}
\arguments{
\item{y}{A response vector.}

\item{x}{A covariate matrix for the response y.}

\item{w}{A covariate matrix for the missing indicator cc.}

\item{cc}{A missing incidator vector (1=obserced, 0=missing) .}

\item{nu}{The initial value for the degrees of freedom.}

\item{family}{The family to be used (Normal or T).}

\item{error}{The abslute convergence error for the EM stopping rule.}

\item{iter.max}{The maximum number of iterations for the EM algorithm.}

\item{im}{TRUE/FALSE, boolean to decide if the standard erros of the parameters should be computed.}

\item{criteria}{TRUE/FALSE, boolean to decide if the model selection criteria should be computed.}
}
\value{
An object of the class HeckmanEM with all the outputs provided from the function.
}
\description{
`HeckmanEM()` fit the Heckman selection model.
}
\examples{
n <- 100
family <- "T"
nu <- 4
rho <- .6
cens <- .25

set.seed(20200527)
w <- cbind(1,runif(n,-1,1),rnorm(n))
x <- cbind(w[,1:2])
c <- qt(cens, df=nu)

sigma2 <- 1

beta <- c(1,0.5)
gamma <- c(1,0.3,-.5)
gamma[1] <- -c*sqrt(sigma2)

set.seed(1)
datas <- rHeckman(x,w,beta,gamma,sigma2,rho,nu,family=family)
y <- datas$y
cc <- datas$cc
\donttest{
# Normal EM
res.N <- HeckmanEM(y, x, w, cc, nu = 4, family="Normal", error = 1e-05, iter.max = 50,
                   im=TRUE, criteria = TRUE)
# Student-t: EM
res.T <- HeckmanEM(y, x, w, cc, nu = 4, family="T", error = 1e-05, iter.max = 50,
                   im=TRUE, criteria = TRUE)
}
}
