% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tenfold_split.R
\name{tenfold_split}
\alias{tenfold_split}
\alias{twofold_split}
\title{Data split}
\usage{
tenfold_split(index_all, strat = NULL, method = "simple")

twofold_split(
  index_all,
  train_proportion = 0.5,
  strat = NULL,
  method = "simple"
)
}
\arguments{
\item{index_all}{a vector of the indexes of all the individuals.}

\item{strat}{a vector of the variable (usually the outcome)
based on which the data is going to be stratified.
This only works when method="stratified".
By default, strat=NULL.}

\item{method}{the method to be used for data split, either "simple" (default) or "stratified".}

\item{train_proportion}{a positive number between 0 and 1 giving
the proportion of the training dataset when splitting data into 2 folds.
By default, train_proportion=0.5.}
}
\value{
a list containing the indexes of different folds.
}
\description{
\code{\link{tenfold_split}} splits data into ten folds, which is used for cross-validation.
\code{\link{twofold_split}} splits data into two folds, which samples the training set.
Both stratified sampling and simple sampling are allowed.
The details can be found in function \code{\link{do_cv}} and \code{\link{do_cumulative_htrx}}.
}
\details{
Stratified sampling works only when the "strat" variable is binary (either 0 or 1),
and it ensures each fold has almost the same number of strat=0 and strat=1.

Simple sampling randomly splits the data into k folds (k=2 or 10).

Two-fold data split is used to select candidate models in Step 1 of HTRX or cumulative HTRX,
while 10-fold data split is used for 10-fold cross-validation in Step 2 which aims at selecting the best model.
}
\examples{
## create the binary outcome (20\% prevalence)
outcome=rbinom(200,1,0.2)

## simple sampling (10 folds)
tenfold_split(1:200)

## stratified sampling (10 folds)
tenfold_split(1:200,outcome,"stratified")

## simple sampling (2 folds, with 50\% training data)
twofold_split(1:200,0.5)

## stratified sampling (2 folds, with 50\% training data)
twofold_split(1:200,0.5,outcome,"stratified")
}
